/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DomPsiConverter;
import com.android.tools.idea.lint.LintIdePosition;
import com.android.tools.idea.lint.LintIdeUtils;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DomPsiParser
extends XmlParser {
    private final LintClient myClient;
    private AccessToken myReadLock;

    public DomPsiParser(LintClient client) {
        this.myClient = client;
    }

    public void dispose(XmlContext context, Document document) {
        if (context.document != null) {
            this.myReadLock.finish();
            this.myReadLock = null;
            context.document = null;
        }
    }

    public int getNodeStartOffset(XmlContext context, Node node) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        return textRange.getStartOffset();
    }

    public int getNodeEndOffset(XmlContext context, Node node) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        return textRange.getEndOffset();
    }

    public Node findNodeAt(XmlContext context, int offset) {
        return DomPsiConverter.findNodeAt(context.document, offset);
    }

    public Document parseXml(XmlContext context) {
        assert (this.myReadLock == null);
        this.myReadLock = ApplicationManager.getApplication().acquireReadActionLock();
        Document document = this.parse(context);
        if (document == null) {
            this.myReadLock.finish();
            this.myReadLock = null;
        }
        return document;
    }

    private Document parse(XmlContext context) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        PsiFile psiFile = LintIdeUtils.getPsiFile((Context)context);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        try {
            return DomPsiConverter.convert(xmlFile);
        }
        catch (Throwable t) {
            this.myClient.log(t, "Failed converting PSI parse tree to DOM for file %1$s", new Object[]{context.file.getPath()});
            return null;
        }
    }

    public Location getLocation(XmlContext context, Node node) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        LintXmlPosition start = new LintXmlPosition(node, textRange.getStartOffset());
        LintXmlPosition end = new LintXmlPosition(node, textRange.getEndOffset());
        return Location.create((File)context.file, (Position)start, (Position)end);
    }

    public Location getLocation(XmlContext context, Node node, int startDelta, int endDelta) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        LintXmlPosition start = new LintXmlPosition(node, textRange.getStartOffset() + startDelta);
        LintXmlPosition end = new LintXmlPosition(node, textRange.getStartOffset() + endDelta);
        return Location.create((File)context.file, (Position)start, (Position)end);
    }

    public Location getNameLocation(XmlContext context, Node node) {
        TextRange textRange = DomPsiConverter.getTextNameRange(node);
        LintXmlPosition start = new LintXmlPosition(node, textRange.getStartOffset());
        LintXmlPosition end = new LintXmlPosition(node, textRange.getEndOffset());
        return Location.create((File)context.file, (Position)start, (Position)end);
    }

    public Location getValueLocation(XmlContext context, Attr node) {
        TextRange textRange = DomPsiConverter.getTextValueRange(node);
        LintXmlPosition start = new LintXmlPosition(node, textRange.getStartOffset());
        LintXmlPosition end = new LintXmlPosition(node, textRange.getEndOffset());
        return Location.create((File)context.file, (Position)start, (Position)end);
    }

    public Location.Handle createLocationHandle(XmlContext context, Node node) {
        return new LocationHandle(context.file, node);
    }

    private static class LocationHandle
    implements Location.Handle {
        private final File myFile;
        private final Node myNode;
        private Object myClientData;

        public LocationHandle(File file, Node node) {
            this.myFile = file;
            this.myNode = node;
        }

        public Location resolve() {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (Location)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Location>(){

                    public Location compute() {
                        return this.resolve();
                    }
                });
            }
            TextRange textRange = DomPsiConverter.getTextRange(this.myNode);
            LintXmlPosition start = new LintXmlPosition(this.myNode, textRange.getStartOffset());
            LintXmlPosition end = new LintXmlPosition(this.myNode, textRange.getEndOffset());
            return Location.create((File)this.myFile, (Position)start, (Position)end);
        }

        public void setClientData(Object clientData) {
            this.myClientData = clientData;
        }

        public Object getClientData() {
            return this.myClientData;
        }
    }

    private static class LintXmlPosition
    extends LintIdePosition {
        private Node myNode;

        public LintXmlPosition(Node node, int offset) {
            super(offset);
            this.myNode = node;
        }

        @Override
        protected void initializeLineColumn() {
            XmlElement element = DomPsiConverter.getPsiElement(this.myNode);
            ApplicationManager.getApplication().assertReadAccessAllowed();
            PsiFile file = element.getContainingFile();
            if (file != null && file.isValid()) {
                String contents = file.getText();
                this.initializeFromText(contents);
            }
        }
    }
}

