/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.run.LoggingReceiver;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public final class AndroidLogcatService
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    private final Map<IDevice, List<LogcatListener>> myListeners = new HashMap<IDevice, List<LogcatListener>>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, LogcatBuffer> myLogBuffers = new HashMap<IDevice, LogcatBuffer>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, AndroidLogcatReceiver> myLogReceivers = new HashMap<IDevice, AndroidLogcatReceiver>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, ExecutorService> myExecutors = new HashMap<IDevice, ExecutorService>();

    private static Logger getLog() {
        return Logger.getInstance(AndroidLogcatService.class);
    }

    @NotNull
    public static AndroidLogcatService getInstance() {
        AndroidLogcatService androidLogcatService = (AndroidLogcatService)ServiceManager.getService(AndroidLogcatService.class);
        if (androidLogcatService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatService", "getInstance"));
        }
        return androidLogcatService;
    }

    AndroidLogcatService() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReceiving(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "startReceiving"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                return;
            }
            this.connect(device);
            AndroidLogcatReceiver receiver = this.createReceiver(device);
            this.myLogReceivers.put(device, receiver);
            this.myLogBuffers.put(device, new LogcatBuffer());
            ExecutorService executor = this.myExecutors.get(device);
            executor.submit(() -> {
                if (device == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "lambda$startReceiving$0"));
                }
                try {
                    AndroidUtils.executeCommandOnDevice(device, "logcat -v long", receiver, true);
                }
                catch (Exception e) {
                    AndroidLogcatService.getLog().info(String.format("Caught exception when capturing logcat output from the device %1$s. Receiving logcat output from this device will be stopped, and the listeners will be notified with this exception as the last message", device.getName()), (Throwable)e);
                    LogCatHeader dummyHeader = new LogCatHeader(Log.LogLevel.ERROR, 0, 0, "?", "Internal", LogCatTimestamp.ZERO);
                    receiver.notifyLine(dummyHeader, e.getMessage());
                }
            });
        }
    }

    @NotNull
    private AndroidLogcatReceiver createReceiver(final @NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "createReceiver"));
        }
        LogcatListener logcatListener = new LogcatListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLogLineReceived(@NotNull LogCatMessage line) {
                if (line == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatService$1", "onLogLineReceived"));
                }
                Object object = AndroidLogcatService.this.myLock;
                synchronized (object) {
                    if (AndroidLogcatService.this.myListeners.containsKey(device)) {
                        for (LogcatListener listener : (List)AndroidLogcatService.this.myListeners.get(device)) {
                            listener.onLogLineReceived(line);
                        }
                    }
                    if (AndroidLogcatService.this.myLogBuffers.containsKey(device)) {
                        ((LogcatBuffer)AndroidLogcatService.this.myLogBuffers.get(device)).addMessage(line);
                    }
                }
            }
        };
        AndroidLogcatReceiver androidLogcatReceiver = new AndroidLogcatReceiver(device, logcatListener);
        if (androidLogcatReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatService", "createReceiver"));
        }
        return androidLogcatReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "connect"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myExecutors.containsKey(device)) {
                ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("logcat-" + device.getName()).build();
                this.myExecutors.put(device, Executors.newSingleThreadExecutor(factory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "disconnect"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.stopReceiving(device);
            this.myExecutors.remove(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReceiving(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "stopReceiving"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                this.myLogReceivers.get(device).cancel();
                this.myLogReceivers.remove(device);
                this.myLogBuffers.remove(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogcat(@NotNull IDevice device, @NotNull Project project) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "clearLogcat"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/logcat/AndroidLogcatService", "clearLogcat"));
        }
        Object object = this.myLock;
        synchronized (object) {
            ExecutorService executor = this.myExecutors.get(device);
            if (executor != null) {
                this.stopReceiving(device);
                executor.submit(() -> {
                    if (device == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "lambda$clearLogcat$2"));
                    }
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/logcat/AndroidLogcatService", "lambda$clearLogcat$2"));
                    }
                    try {
                        AndroidUtils.executeCommandOnDevice(device, "logcat -c", new LoggingReceiver(AndroidLogcatService.getLog()), false);
                    }
                    catch (Exception e) {
                        AndroidLogcatService.getLog().info((Throwable)e);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/logcat/AndroidLogcatService", "lambda$null$1"));
                            }
                            Messages.showErrorDialog((Project)project, (String)("Error: " + e.getMessage()), (String)AndroidBundle.message("android.logcat.error.dialog.title", new Object[0]));
                        });
                    }
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.myListeners.containsKey(device)) {
                            for (LogcatListener listener : this.myListeners.get(device)) {
                                listener.onCleared();
                            }
                        }
                    }
                });
                this.startReceiving(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener, boolean addOldLogs) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "addListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/logcat/AndroidLogcatService", "addListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (addOldLogs && this.myLogBuffers.containsKey(device)) {
                for (LogCatMessage line : this.myLogBuffers.get(device).getMessages()) {
                    listener.onLogLineReceived(line);
                }
            }
            if (!this.myListeners.containsKey(device)) {
                this.myListeners.put(device, new ArrayList());
            }
            this.myListeners.get(device).add(listener);
            if (device.isOnline()) {
                this.startReceiving(device);
            }
        }
    }

    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "addListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/logcat/AndroidLogcatService", "addListener"));
        }
        this.addListener(device, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull IDevice device, @NotNull LogcatListener listener) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "removeListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/logcat/AndroidLogcatService", "removeListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myListeners.containsKey(device)) {
                this.myListeners.get(device).remove(listener);
                if (this.myListeners.get(device).isEmpty()) {
                    this.stopReceiving(device);
                }
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "deviceConnected"));
        }
        if (device.isOnline()) {
            this.startReceiving(device);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "deviceDisconnected"));
        }
        this.disconnect(device);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatService", "deviceChanged"));
        }
        if (device.isOnline()) {
            this.startReceiving(device);
        } else {
            this.disconnect(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        Object object = this.myLock;
        synchronized (object) {
            for (AndroidLogcatReceiver receiver : this.myLogReceivers.values()) {
                receiver.cancel();
            }
        }
    }

    public static interface LogcatListener {
        default public void onLogLineReceived(@NotNull LogCatMessage line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatService$LogcatListener", "onLogLineReceived"));
            }
        }

        default public void onCleared() {
        }
    }

    private static class LogcatBuffer {
        private int myBufferSize;
        private final LinkedList<LogCatMessage> myMessages = new LinkedList();

        private LogcatBuffer() {
        }

        public void addMessage(@NotNull LogCatMessage message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/logcat/AndroidLogcatService$LogcatBuffer", "addMessage"));
            }
            this.myMessages.add(message);
            this.myBufferSize += message.getMessage().length();
            if (ConsoleBuffer.useCycleBuffer()) {
                while (this.myBufferSize > ConsoleBuffer.getCycleBufferSize()) {
                    this.myBufferSize -= this.myMessages.removeFirst().getMessage().length();
                }
            }
        }

        @NotNull
        public List<LogCatMessage> getMessages() {
            LinkedList<LogCatMessage> linkedList = this.myMessages;
            if (linkedList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatService$LogcatBuffer", "getMessages"));
            }
            return linkedList;
        }
    }
}

