/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.model;

import com.android.tools.adtui.chart.hchart.Method;
import com.android.tools.adtui.model.HNode;
import com.android.tools.idea.monitor.ui.cpu.model.AppTrace;
import com.android.tools.perflib.vmtrace.Call;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.android.tools.perflib.vmtrace.VmTraceParser;
import com.android.utils.SparseArray;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TraceArt
extends AppTrace {
    private final File myTraceFile;
    SparseArray<HNode<Method>> myNodes;
    private VmTraceData myData;

    public TraceArt(File traceFile) {
        this.myTraceFile = traceFile;
    }

    @Override
    public AppTrace.Source getSource() {
        return AppTrace.Source.ART;
    }

    @Override
    public String getSeparator() {
        return ".";
    }

    @Override
    public void parse() throws IOException {
        VmTraceParser parser = new VmTraceParser(this.myTraceFile);
        parser.parse();
        this.myData = parser.getTraceData();
        this.myNodes = new SparseArray();
        for (ThreadInfo threadInfo : this.myData.getThreads()) {
            if (threadInfo.getTopLevelCall() == null || threadInfo.getTopLevelCall().getCallees().size() == 0) continue;
            Call firstCall = (Call)threadInfo.getTopLevelCall().getCallees().get(0);
            HNode root = new HNode();
            root.setStart(firstCall.getEntryTime(ClockType.GLOBAL, TimeUnit.MICROSECONDS) + this.myData.getStartTimeUs());
            root.setEnd(firstCall.getExitTime(ClockType.GLOBAL, TimeUnit.MICROSECONDS) + this.myData.getStartTimeUs());
            this.myNodes.put(threadInfo.getId(), (Object)root);
            this.convertCallsToNode(Arrays.asList(firstCall), root, 0);
        }
    }

    private void convertCallsToNode(List<Call> calls, HNode root, int depth) {
        for (Call c : calls) {
            HNode node = new HNode();
            node.setStart(c.getEntryTime(ClockType.GLOBAL, TimeUnit.MICROSECONDS) + this.myData.getStartTimeUs());
            node.setEnd(c.getExitTime(ClockType.GLOBAL, TimeUnit.MICROSECONDS) + this.myData.getStartTimeUs());
            node.setDepth(depth);
            Method method = new Method();
            method.setName(this.myData.getMethod((long)c.getMethodId()).methodName);
            method.setNamespace(this.myData.getMethod((long)c.getMethodId()).className);
            node.setData((Object)method);
            root.addHNode(node);
            this.convertCallsToNode(c.getCallees(), node, depth + 1);
        }
    }

    @Override
    public SparseArray<HNode<Method>> getThreadsGraph() {
        return this.myNodes;
    }
}

