/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.energy.view;

import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.energy.model.EnergyPoller;
import com.android.tools.idea.monitor.ui.energy.view.EnergySegment;
import com.google.common.collect.Sets;
import com.intellij.util.EventDispatcher;
import icons.AndroidIcons;
import java.awt.Component;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyProfilerUiManager
extends BaseProfilerUiManager {
    private JButton myToggleDeltaButton;
    private EnergyPoller myEnergyPoller;
    private boolean myIsDisplayingInstantaneousEnergyUsage;

    public EnergyProfilerUiManager(@NotNull Range timeCurrentRangeUs, @NotNull Choreographer choreographer, @NotNull SeriesDataStore datastore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "<init>"));
        }
        if (choreographer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choreographer", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "<init>"));
        }
        if (datastore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "datastore", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "<init>"));
        }
        if (eventDispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventDispatcher", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "<init>"));
        }
        super(timeCurrentRangeUs, choreographer, datastore, eventDispatcher);
        this.myIsDisplayingInstantaneousEnergyUsage = true;
    }

    @Override
    @Nullable
    public Set<Poller> createPollers(int pid) {
        this.myEnergyPoller = new EnergyPoller(this.myDataStore, pid, this.myIsDisplayingInstantaneousEnergyUsage);
        return Sets.newHashSet((Object[])new Poller[]{this.myEnergyPoller});
    }

    public void toggleDisplayInstantaneousEnergyUsage() {
        this.myIsDisplayingInstantaneousEnergyUsage = !this.myIsDisplayingInstantaneousEnergyUsage;
        for (SeriesDataType type : EnergyPoller.ENERGY_DATA_TYPES) {
            this.myEnergyPoller.getEnergyAdapter(type).setReturnInstantaneousData(this.myIsDisplayingInstantaneousEnergyUsage);
        }
    }

    @Override
    public void setupExtendedOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "setupExtendedOverviewUi"));
        }
        if (overviewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overviewPanel", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "setupExtendedOverviewUi"));
        }
        super.setupExtendedOverviewUi(toolbar, overviewPanel);
        this.myToggleDeltaButton = new JButton(AndroidIcons.Ddms.SysInfo);
        this.myToggleDeltaButton.addActionListener(e -> this.toggleDisplayInstantaneousEnergyUsage());
        toolbar.add((Component)this.myToggleDeltaButton, "LEFT");
    }

    @Override
    @NotNull
    protected BaseSegment createOverviewSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "createOverviewSegment"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "createOverviewSegment"));
        }
        if (eventDispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventDispatcher", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "createOverviewSegment"));
        }
        EnergySegment energySegment = new EnergySegment(timeCurrentRangeUs, dataStore, eventDispatcher);
        if (energySegment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "createOverviewSegment"));
        }
        return energySegment;
    }

    @Override
    public void resetProfiler(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "resetProfiler"));
        }
        if (overviewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overviewPanel", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "resetProfiler"));
        }
        if (detailPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailPanel", "com/android/tools/idea/monitor/ui/energy/view/EnergyProfilerUiManager", "resetProfiler"));
        }
        super.resetProfiler(toolbar, overviewPanel, detailPanel);
        if (this.myToggleDeltaButton != null) {
            toolbar.remove(this.myToggleDeltaButton);
            this.myToggleDeltaButton = null;
        }
    }
}

