/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.IconPickerDialog;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VectorIconButton
extends JButton
implements AssetComponent<VectorAsset>,
Disposable {
    private final VectorAsset myXmlAsset = new VectorAsset(VectorAsset.FileType.VECTOR_DRAWABLE);
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myAssetListeners = Lists.newArrayListWithExpectedSize((int)1);
    @Nullable
    private VdIcon myIcon;

    public VectorIconButton() {
        this.addActionListener(actionEvent -> {
            IconPickerDialog iconPicker = new IconPickerDialog(this.myIcon);
            if (iconPicker.showAndGet()) {
                VdIcon selectedIcon = iconPicker.getSelectedIcon();
                assert (selectedIcon != null);
                this.updateIcon(selectedIcon);
            }
        });
        this.myXmlAsset.path().addListener(sender -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener : this.myAssetListeners) {
                listener.actionPerformed(e);
            }
        });
        this.updateIcon(IconPickerDialog.getDefaultIcon());
    }

    private void updateIcon(@NotNull VdIcon selectedIcon) {
        if (selectedIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedIcon", "com/android/tools/idea/npw/assetstudio/ui/VectorIconButton", "updateIcon"));
        }
        this.myIcon = null;
        this.setIcon(null);
        try {
            File iconFile = new File(FileUtil.getTempDirectory(), selectedIcon.getName());
            InputStream iconStream = selectedIcon.getURL().openStream();
            FileOutputStream outputStream = new FileOutputStream(iconFile);
            FileUtil.copy((InputStream)iconStream, (OutputStream)outputStream);
            this.myXmlAsset.path().set(iconFile);
            int h = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
            VectorAsset.ParseResult result = this.myXmlAsset.parse(h, false);
            BufferedImage image = result.getImage();
            image = VdIcon.adjustIconColor((Component)this, (BufferedImage)image);
            this.setIcon(new ImageIcon(image));
            this.myIcon = selectedIcon;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public VectorAsset getAsset() {
        VectorAsset vectorAsset = this.myXmlAsset;
        if (vectorAsset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/VectorIconButton", "getAsset"));
        }
        return vectorAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/android/tools/idea/npw/assetstudio/ui/VectorIconButton", "addAssetListener"));
        }
        this.myAssetListeners.add(l);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myAssetListeners.clear();
    }
}

