/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class NdkProjectInfo {
    private static final Key<Boolean> HAS_NDK_MODULES = Key.create((String)"HAS_NDK_MODULES");
    @NotNull
    private final Project myProject;

    private NdkProjectInfo(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/NdkProjectInfo", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public static NdkProjectInfo get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/NdkProjectInfo", "get"));
        }
        NdkProjectInfo ndkProjectInfo = new NdkProjectInfo(project);
        if (ndkProjectInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/project/NdkProjectInfo", "get"));
        }
        return ndkProjectInfo;
    }

    public void setHasNdkModules(boolean hasNativeModules) {
        this.myProject.putUserData(HAS_NDK_MODULES, (Object)hasNativeModules);
    }

    public boolean hasNdkModules() {
        Boolean value = (Boolean)this.myProject.getUserData(HAS_NDK_MODULES);
        return value != null ? value : false;
    }
}

