/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderParamsFlags;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ParserFactory;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.idea.rendering.LayoutFilePullParser;
import com.android.tools.idea.rendering.LayoutMetadata;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.util.Pair;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ViewLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutlibCallbackImpl
extends LayoutlibCallback {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.LayoutlibCallback");
    private static final int MAX_PARSER_INCLUDES = 50;
    private static final Set<String> NOT_VIEW = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"android.support.v7.widget.RecyclerView$Adapter", "android.support.v7.widget.RecyclerView$LayoutManager", "android.support.v7.internal.app.WindowDecorActionBar"}));
    public static final String FD_LAYOUTLIB = "layoutlib";
    @NotNull
    private final Module myModule;
    @NotNull
    private final AppResourceRepository myProjectRes;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @Nullable
    private final Object myCredential;
    private final boolean myHasAppCompat;
    @Nullable
    private String myNamespace;
    @Nullable
    private RenderLogger myLogger;
    @NotNull
    private final ViewLoader myClassLoader;
    @Nullable
    private String myLayoutName;
    @Nullable
    private ILayoutPullParser myLayoutEmbeddedParser;
    @Nullable
    private ResourceResolver myResourceResolver;
    @Nullable
    private final ActionBarHandler myActionBarHandler;
    @Nullable
    private final RenderTask myRenderTask;
    private boolean myUsed;
    private Set<File> myParserFiles;
    private int myParserCount;
    private ParserFactory myParserFactory;

    public LayoutlibCallbackImpl(@Nullable RenderTask renderTask, @NotNull LayoutLibrary layoutLib, @NotNull AppResourceRepository projectRes, @NotNull Module module, @NotNull AndroidFacet facet, @NotNull RenderLogger logger, @Nullable Object credential, @Nullable ActionBarHandler actionBarHandler) {
        if (layoutLib == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutLib", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "<init>"));
        }
        if (projectRes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRes", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "<init>"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "<init>"));
        }
        this.myUsed = false;
        this.myRenderTask = renderTask;
        this.myLayoutLib = layoutLib;
        this.myProjectRes = projectRes;
        this.myModule = module;
        this.myCredential = credential;
        this.myClassLoader = new ViewLoader(this.myLayoutLib, facet, logger, credential);
        this.myActionBarHandler = actionBarHandler;
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        this.myHasAppCompat = androidModel != null && GradleUtil.dependsOn(androidModel, "com.android.support:appcompat-v7");
        String javaPackage = MergedManifest.get(this.myModule).getPackage();
        this.myNamespace = javaPackage != null && javaPackage.length() > 0 ? "http://schemas.android.com/apk/res/" + javaPackage : "http://schemas.android.com/apk/res-auto";
    }

    void reset() {
        this.myParserCount = 0;
        this.myParserFiles = null;
        this.myLayoutName = null;
        this.myLayoutEmbeddedParser = null;
    }

    public void setLogger(@Nullable RenderLogger logger) {
        this.myLogger = logger;
        this.myClassLoader.setLogger(logger);
    }

    @Nullable
    public LayoutLog getLogger() {
        return this.myLogger;
    }

    @Nullable
    public Object loadView(@NotNull String className, @NotNull Class[] constructorSignature, @NotNull Object[] constructorParameters) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "loadView"));
        }
        if (constructorSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorSignature", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "loadView"));
        }
        if (constructorParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "loadView"));
        }
        this.myUsed = true;
        if (NOT_VIEW.contains(className)) {
            return this.myClassLoader.loadClass(className, constructorSignature, constructorParameters);
        }
        return this.myClassLoader.loadView(className, constructorSignature, constructorParameters);
    }

    public Object loadClass(@NotNull String name, @Nullable Class[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "loadClass"));
        }
        this.myUsed = true;
        return this.myClassLoader.loadClass(name, constructorSignature, constructorArgs);
    }

    public boolean supports(int ideFeature) {
        return ideFeature <= 19;
    }

    @Nullable
    public String getNamespace() {
        return this.myNamespace;
    }

    @Nullable
    public Pair<ResourceType, String> resolveResourceId(int id) {
        return this.myProjectRes.resolveResourceId(id);
    }

    @Nullable
    public String resolveResourceId(int[] id) {
        return this.myProjectRes.resolveStyleable(id);
    }

    @Nullable
    public Integer getResourceId(ResourceType type, String name) {
        return this.myProjectRes.getResourceId(type, name);
    }

    public boolean isUsed() {
        return this.myUsed;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public XmlPullParser getXmlFileParser(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setLayoutParser(@Nullable String layoutName, @Nullable ILayoutPullParser layoutParser) {
        this.myLayoutName = layoutName;
        this.myLayoutEmbeddedParser = layoutParser;
    }

    @Nullable
    public ILayoutPullParser getLayoutEmbeddedParser() {
        return this.myLayoutEmbeddedParser;
    }

    @Nullable
    public ILayoutPullParser getParser(@NotNull String layoutName) {
        ResourceValue value;
        if (layoutName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutName", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "getParser"));
        }
        if (this.myResourceResolver != null && (value = this.myResourceResolver.getProjectResource(ResourceType.LAYOUT, layoutName)) != null) {
            return this.getParser(value);
        }
        return this.getParser(layoutName, false, null);
    }

    @Nullable
    public ILayoutPullParser getParser(@NotNull ResourceValue layoutResource) {
        if (layoutResource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutResource", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "getParser"));
        }
        return this.getParser(layoutResource.getName(), layoutResource.isFramework(), new File(layoutResource.getValue()));
    }

    @Nullable
    private ILayoutPullParser getParser(@NotNull String layoutName, boolean isFramework, @Nullable File xml) {
        if (layoutName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutName", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "getParser"));
        }
        if (this.myParserFiles != null && this.myParserFiles.contains(xml)) {
            if (this.myParserCount > 50) {
                if (this.findCycles()) {
                    throw new RuntimeException("Aborting rendering");
                }
                this.myParserCount = 0;
            }
        } else {
            if (this.myParserFiles == null) {
                this.myParserFiles = Sets.newHashSet();
            }
            this.myParserFiles.add(xml);
        }
        ++this.myParserCount;
        if (layoutName.equals(this.myLayoutName) && !isFramework) {
            ILayoutPullParser parser = this.myLayoutEmbeddedParser;
            this.myLayoutEmbeddedParser = null;
            return parser;
        }
        if (xml != null && xml.isFile()) {
            PsiFile psiFile;
            VirtualFile file;
            String parentName;
            File parent = xml.getParentFile();
            String path = xml.getPath();
            if (parent != null && !path.contains("exploded-aar") && !path.contains(FD_LAYOUTLIB) && ((parentName = parent.getName()).startsWith("layout") || parentName.startsWith("menu")) && (file = LocalFileSystem.getInstance().findFileByIoFile(xml)) != null && (psiFile = AndroidPsiUtils.getPsiFileSafely(this.myModule.getProject(), file)) instanceof XmlFile) {
                assert (this.myLogger != null);
                LayoutPsiPullParser parser = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger);
                parser.setUseSrcCompat(this.myHasAppCompat);
                if (parentName.startsWith("layout")) {
                    parser.setProvideViewCookies(this.myRenderTask != null && this.myRenderTask.getProvideCookiesForIncludedViews());
                }
                return parser;
            }
            try {
                return LayoutFilePullParser.create(this, xml);
            }
            catch (XmlPullParserException e) {
                LOG.error((Throwable)e);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private boolean findCycles() {
        HashMap fileToLayout = Maps.newHashMap();
        HashMap layoutToFile = Maps.newHashMap();
        ArrayListMultimap includeMap = ArrayListMultimap.create();
        for (File file : this.myParserFiles) {
            String layoutName = LintUtils.getLayoutName((File)file);
            layoutToFile.put(layoutName, file);
            fileToLayout.put(file, layoutName);
            try {
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null) continue;
                NodeList includeNodeList = document.getElementsByTagName("include");
                int n = includeNodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Element include = (Element)includeNodeList.item(i);
                    String included = include.getAttribute("layout");
                    if (!included.startsWith("@layout/")) continue;
                    String resource = included.substring("@layout/".length());
                    includeMap.put((Object)layoutName, (Object)resource);
                }
                NodeList fragmentNodeList = document.getElementsByTagName("fragment");
                int n2 = fragmentNodeList.getLength();
                for (int i = 0; i < n2; ++i) {
                    Element fragment = (Element)fragmentNodeList.item(i);
                    String included = fragment.getAttributeNS("http://schemas.android.com/tools", "layout");
                    if (!included.startsWith("@layout/")) continue;
                    String resource = included.substring("@layout/".length());
                    includeMap.put((Object)layoutName, (Object)resource);
                }
            }
            catch (IOException e) {
                LOG.warn("Could not check file " + file + " for cyclic dependencies", (Throwable)e);
            }
        }
        if (includeMap.size() > 0) {
            for (String from : includeMap.keySet()) {
                HashSet visiting;
                List<String> chain = LayoutlibCallbackImpl.dfs(from, visiting = Sets.newHashSetWithExpectedSize((int)includeMap.size()), (Multimap<String, String>)includeMap);
                if (chain == null) continue;
                if (this.myLogger != null) {
                    RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                    HtmlBuilder builder = problem.getHtmlBuilder();
                    builder.add("Found cyclical <include> chain: ");
                    boolean first = true;
                    Collections.reverse(chain);
                    for (String layout : chain) {
                        if (first) {
                            first = false;
                        } else {
                            builder.add(" includes ");
                        }
                        File file = (File)layoutToFile.get(layout);
                        if (file != null) {
                            try {
                                String url = SdkUtils.fileToUrlString((File)file);
                                builder.addLink(layout, url);
                            }
                            catch (MalformedURLException e) {
                                builder.add(layout);
                            }
                            continue;
                        }
                        builder.add(layout);
                    }
                    this.myLogger.addMessage(problem);
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static List<String> dfs(String from, Set<String> visiting, Multimap<String, String> includeMap) {
        visiting.add(from);
        Collection includes = includeMap.get((Object)from);
        if (includes != null && includes.size() > 0) {
            for (String include : includes) {
                if (visiting.contains(include)) {
                    LinkedList list = Lists.newLinkedList();
                    list.add(include);
                    list.add(from);
                    return list;
                }
                List<String> chain = LayoutlibCallbackImpl.dfs(include, visiting, includeMap);
                if (chain == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }

    @Nullable
    public Object getAdapterItemValue(ResourceReference adapterView, Object adapterCookie, ResourceReference itemRef, int fullPosition, int typePosition, int fullChildPosition, int typeChildPosition, ResourceReference viewRef, IProjectCallback.ViewAttribute viewAttribute, Object defaultValue) {
        if (viewAttribute == IProjectCallback.ViewAttribute.TEXT && adapterView.getName().startsWith("android_widget_")) {
            String name = adapterView.getName();
            if (viewRef.getName().equals("text2")) {
                return "Sub Item";
            }
            if (fullPosition == 0) {
                String viewName = name.substring("android_widget_".length());
                if (viewName.equals("ExpandableListView")) {
                    return "ExpandableList";
                }
                return viewName;
            }
            return "Next Item";
        }
        if (itemRef.isFramework() && viewRef.getName().equals("text2")) {
            return "Sub Item " + (fullPosition + 1);
        }
        if (viewAttribute == IProjectCallback.ViewAttribute.TEXT && ((String)defaultValue).length() == 0) {
            return "Item " + (fullPosition + 1);
        }
        return null;
    }

    @Nullable
    public static String getListAdapterViewFqcn(@NotNull Class<?> clz) {
        if (clz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clz", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "getListAdapterViewFqcn"));
        }
        String fqcn = clz.getName();
        if (fqcn.endsWith("ListView") || fqcn.equals("android.widget.GridView") || fqcn.equals("android.widget.Spinner")) {
            return fqcn;
        }
        if (fqcn.startsWith("android.")) {
            return null;
        }
        Class<?> superClass = clz.getSuperclass();
        if (superClass != null) {
            return LayoutlibCallbackImpl.getListAdapterViewFqcn(superClass);
        }
        return null;
    }

    private boolean isWithinIllegalParent(@NotNull Object viewObject, int depth) {
        Object parent;
        Result result;
        if (viewObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewObject", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "isWithinIllegalParent"));
        }
        String fqcn = viewObject.getClass().getName();
        if (fqcn.endsWith("CalendarView") || !fqcn.startsWith("android.") && !fqcn.startsWith("com.android.internal.widget.")) {
            return true;
        }
        if (depth > 0 && (result = this.myLayoutLib.getViewParent(viewObject)).isSuccess() && (parent = result.getData()) != null) {
            return this.isWithinIllegalParent(parent, depth - 1);
        }
        return false;
    }

    @Nullable
    public AdapterBinding getAdapterBinding(ResourceReference adapterView, Object adapterCookie, Object viewObject) {
        Map map;
        AdapterBinding binding;
        AdapterBinding binding2;
        if (adapterCookie instanceof TagSnapshot) {
            binding2 = LayoutMetadata.getNodeBinding(viewObject, (TagSnapshot)adapterCookie);
            if (binding2 != null) {
                return binding2;
            }
        } else if (adapterCookie instanceof XmlTag) {
            binding2 = LayoutMetadata.getNodeBinding(viewObject, TagSnapshot.createTagSnapshotWithoutChildren((XmlTag)adapterCookie));
            if (binding2 != null) {
                return binding2;
            }
        } else if (adapterCookie instanceof Map && (binding = LayoutMetadata.getNodeBinding(viewObject, map = (Map)adapterCookie)) != null) {
            return binding;
        }
        if (viewObject == null) {
            return null;
        }
        String listFqcn = LayoutlibCallbackImpl.getListAdapterViewFqcn(viewObject.getClass());
        if (listFqcn == null) {
            return null;
        }
        if (this.isWithinIllegalParent(viewObject, 2)) {
            return null;
        }
        int count = listFqcn.endsWith("GridView") ? 24 : 12;
        AdapterBinding binding3 = new AdapterBinding(count);
        if (listFqcn.endsWith("ExpandableListView")) {
            binding3.addItem(new DataBindingItem("simple_expandable_list_item_2", true, 1));
        } else if (listFqcn.equals("android.widget.Spinner")) {
            binding3.addItem(new DataBindingItem("simple_spinner_item", true, 1));
        } else {
            binding3.addItem(new DataBindingItem("simple_list_item_2", true, 1));
        }
        return binding3;
    }

    public void setResourceResolver(@Nullable ResourceResolver resolver) {
        this.myResourceResolver = resolver;
    }

    public void loadAndParseRClass() {
        this.myClassLoader.loadAndParseRClassSilently();
    }

    public ActionBarCallback getActionBarCallback() {
        return this.myActionBarHandler;
    }

    @Nullable
    public ActionBarHandler getActionBarHandler() {
        return this.myActionBarHandler;
    }

    @Nullable
    public <T> T getFlag(@NotNull SessionParams.Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "getFlag"));
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_APPLICATION_PACKAGE)) {
            return (T)this.getPackage();
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT)) {
            return (T)Boolean.TRUE;
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_XML_FILE_PARSER_SUPPORT)) {
            return (T)Boolean.TRUE;
        }
        return null;
    }

    @Nullable
    private String getPackage() {
        AndroidModuleInfo info = AndroidModuleInfo.get(this.myModule);
        return info == null ? null : info.getPackage();
    }

    @NotNull
    public ParserFactory getParserFactory() {
        if (this.myParserFactory == null) {
            this.myParserFactory = new ParserFactoryImpl();
        }
        ParserFactory parserFactory = this.myParserFactory;
        if (parserFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "getParserFactory"));
        }
        return parserFactory;
    }

    @NotNull
    public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        block5: {
            Class<?> clazz;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "findClass"));
            }
            try {
                Class<?> aClass = this.myClassLoader.loadClass(name, false);
                if (aClass == null) break block5;
                clazz = aClass;
            }
            catch (InconvertibleClassError e) {
                throw new ClassNotFoundException(name + " not found.", e);
            }
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutlibCallbackImpl", "findClass"));
            }
            return clazz;
        }
        throw new ClassNotFoundException(name + " not found.");
    }

    private static class NamedParser
    extends KXmlParser {
        @Nullable
        private final String myName;
        private boolean hasToolsNamespace;

        public NamedParser(@Nullable String name) {
            this.myName = name;
        }

        public int next() throws XmlPullParserException, IOException {
            int tagType = super.next();
            if (!this.hasToolsNamespace && tagType == 2 || this.hasToolsNamespace && tagType == 3) {
                this.hasToolsNamespace = this.getNamespace("tools") != null;
            }
            return tagType;
        }

        public String getAttributeValue(String namespace, String name) {
            String toolsValue;
            if (this.hasToolsNamespace && "http://schemas.android.com/apk/res/android".equals(namespace) && (toolsValue = super.getAttributeValue("http://schemas.android.com/tools", name)) != null) {
                return toolsValue;
            }
            return super.getAttributeValue(namespace, name);
        }

        public String toString() {
            return this.myName != null ? this.myName : super.toString();
        }
    }

    private static class ParserFactoryImpl
    extends ParserFactory {
        private ParserFactoryImpl() {
        }

        @NotNull
        public XmlPullParser createParser(@Nullable String debugName) throws XmlPullParserException {
            NamedParser namedParser = new NamedParser(debugName);
            if (namedParser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutlibCallbackImpl$ParserFactoryImpl", "createParser"));
            }
            return namedParser;
        }
    }
}

