/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.XmlUtils;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public class MenuLayoutParserFactory
extends LayoutPullParserFactory {
    @NotNull
    private static final String FRAME_LAYOUT_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<FrameLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\" />\n";
    @NotNull
    private final RenderTask myRenderTask;

    public MenuLayoutParserFactory(@NotNull RenderTask renderTask) {
        if (renderTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderTask", "com/android/tools/idea/rendering/MenuLayoutParserFactory", "<init>"));
        }
        assert (renderTask.supportsCapability(12)) : "Action Bar not supported.";
        this.myRenderTask = renderTask;
    }

    @NotNull
    public ILayoutPullParser render() {
        Document frameLayoutDocument = XmlUtils.parseDocumentSilently((String)FRAME_LAYOUT_XML, (boolean)true);
        if (frameLayoutDocument == null) {
            ILayoutPullParser iLayoutPullParser = MenuLayoutParserFactory.createEmptyParser();
            if (iLayoutPullParser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/MenuLayoutParserFactory", "render"));
            }
            return iLayoutPullParser;
        }
        XmlFile psiFile = this.myRenderTask.getPsiFile();
        if (psiFile == null) {
            throw new IllegalStateException("RenderTask should have PsiFile to render menu files");
        }
        String resourceName = ResourceHelper.getResourceName((PsiFile)psiFile);
        ActionBarHandler actionBarHandler = this.myRenderTask.getLayoutlibCallback().getActionBarHandler();
        if (actionBarHandler != null) {
            actionBarHandler.setMenuIdNames(Collections.singletonList(resourceName));
        }
        HashMap viewCookies = Maps.newHashMap();
        DomPullParser domPullParser = new DomPullParser(frameLayoutDocument.getDocumentElement()).setViewCookies(viewCookies);
        if (domPullParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/MenuLayoutParserFactory", "render"));
        }
        return domPullParser;
    }
}

