/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.RenderErrorContributor;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.intellij.openapi.actionSystem.DataContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderErrorModelFactory {
    private RenderErrorModelFactory() {
    }

    @NotNull
    public static RenderErrorModel createErrorModel(@NotNull RenderResult result, @Nullable DataContext dataContext) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/RenderErrorModelFactory", "createErrorModel"));
        }
        ArrayList<RenderErrorModel.Issue> issues = new ArrayList<RenderErrorModel.Issue>();
        for (RenderErrorContributor.Provider provider : (RenderErrorContributor.Provider[])RenderErrorContributor.Provider.EP_NAME.getExtensions()) {
            if (!provider.isApplicable(result.getModule().getProject())) continue;
            issues.addAll(provider.getContributor(result, dataContext).reportIssues());
        }
        RenderErrorModel renderErrorModel = new RenderErrorModel(issues);
        if (renderErrorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderErrorModelFactory", "createErrorModel"));
        }
        return renderErrorModel;
    }
}

