/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunBuildAnalyzer;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.tasks.ClearLogcatTask;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.DeployApkTask;
import com.android.tools.idea.run.tasks.DeployIapkTask;
import com.android.tools.idea.run.tasks.DismissKeyguardTask;
import com.android.tools.idea.run.tasks.LaunchInstantRunServiceTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.ShowLogcatTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLaunchTasksProvider
implements LaunchTasksProvider {
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final Project myProject;
    private final AndroidFacet myFacet;
    private final InstantRunBuildAnalyzer myInstantRunBuildAnalyzer;
    private final ApplicationIdProvider myApplicationIdProvider;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;

    public AndroidLaunchTasksProvider(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @Nullable InstantRunBuildAnalyzer instantRunBuildAnalyzer, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions) {
        if (runConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfig", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        if (applicationIdProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationIdProvider", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        if (launchOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchOptions", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.myInstantRunBuildAnalyzer = instantRunBuildAnalyzer;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myApkProvider = apkProvider;
        this.myLaunchOptions = launchOptions;
    }

    @Override
    @NotNull
    public List<LaunchTask> getTasks(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter consolePrinter) throws ExecutionException {
        String packageName;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
        }
        if (consolePrinter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consolePrinter", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
        }
        ArrayList launchTasks = Lists.newArrayList();
        if (this.myLaunchOptions.isClearLogcatBeforeStart()) {
            launchTasks.add(new ClearLogcatTask(this.myProject));
        }
        launchTasks.add(new DismissKeyguardTask());
        try {
            LaunchTask appLaunchTask;
            launchTasks.addAll(this.getDeployTasks(device));
            packageName = this.myApplicationIdProvider.getPackageName();
            if (this.myInstantRunBuildAnalyzer != null) {
                launchTasks.add(new LaunchInstantRunServiceTask(packageName));
            }
            if ((appLaunchTask = this.myRunConfig.getApplicationLaunchTask(this.myApplicationIdProvider, this.myFacet, this.myLaunchOptions.isDebug(), launchStatus)) != null) {
                launchTasks.add(appLaunchTask);
            }
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidLaunchTasksProvider.class).error((Throwable)e);
            launchStatus.terminateLaunch("Unable to determine application id: " + e);
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
            }
            return list;
        }
        catch (IllegalStateException e) {
            Logger.getInstance(AndroidLaunchTasksProvider.class).error((Throwable)e);
            launchStatus.terminateLaunch(e.getMessage());
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
            }
            return list;
        }
        if (!this.myLaunchOptions.isDebug() && this.myLaunchOptions.isOpenLogcatAutomatically()) {
            launchTasks.add(new ShowLogcatTask(this.myProject, packageName));
        }
        if (this.myInstantRunBuildAnalyzer != null) {
            launchTasks.add(this.myInstantRunBuildAnalyzer.getNotificationTask());
        }
        for (AndroidLaunchTaskContributor taskContributor : (AndroidLaunchTaskContributor[])AndroidLaunchTaskContributor.EP_NAME.getExtensions()) {
            if (!taskContributor.isApplicable(this.myFacet.getModule())) continue;
            launchTasks.add(taskContributor.getTask(packageName));
        }
        ArrayList arrayList = launchTasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
        }
        return arrayList;
    }

    @NotNull
    private List<LaunchTask> getDeployTasks(@NotNull IDevice device) throws ApkProvisionException, ExecutionException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getDeployTasks"));
        }
        if (this.myInstantRunBuildAnalyzer != null) {
            List<LaunchTask> list = this.myInstantRunBuildAnalyzer.getDeployTasks(this.myLaunchOptions);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getDeployTasks"));
            }
            return list;
        }
        if (!this.myLaunchOptions.isDeploy()) {
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getDeployTasks"));
            }
            return list;
        }
        if (this.myFacet.getProjectType() == 4) {
            ImmutableList immutableList = ImmutableList.of((Object)new DeployIapkTask(this.myApkProvider.getApks(device)));
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getDeployTasks"));
            }
            return immutableList;
        }
        InstantRunManager.LOG.info("Using legacy/main APK deploy task");
        ImmutableList immutableList = ImmutableList.of((Object)new DeployApkTask(this.myProject, this.myLaunchOptions, this.myApkProvider.getApks(device)));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getDeployTasks"));
        }
        return immutableList;
    }

    @Override
    @Nullable
    public DebugConnectorTask getConnectDebuggerTask(@NotNull LaunchStatus launchStatus, @Nullable AndroidVersion version) {
        String packageName;
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getConnectDebuggerTask"));
        }
        if (!this.myLaunchOptions.isDebug()) {
            return null;
        }
        Logger logger = Logger.getInstance(AndroidLaunchTasksProvider.class);
        HashSet packageIds = Sets.newHashSet();
        try {
            packageName = this.myApplicationIdProvider.getPackageName();
            packageIds.add(packageName);
        }
        catch (ApkProvisionException e) {
            logger.error((Throwable)e);
        }
        try {
            packageName = this.myApplicationIdProvider.getTestPackageName();
            if (packageName != null) {
                packageIds.add(packageName);
            }
        }
        catch (ApkProvisionException e) {
            logger.warn("Unable to obtain test package name, will not connect debugger if tests don't instantiate main application");
        }
        AndroidDebuggerContext androidDebuggerContext = this.myRunConfig.getAndroidDebuggerContext();
        AndroidDebugger debugger = androidDebuggerContext.getAndroidDebugger();
        if (debugger == null) {
            logger.warn("Unable to determine debugger to use for this launch");
            return null;
        }
        logger.info("Using debugger: " + debugger.getId());
        Object androidDebuggerState = androidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            return debugger.getConnectDebuggerTask(this.myEnv, version, packageIds, this.myFacet, androidDebuggerState, this.myRunConfig.getType().getId(), this.monitorRemoteProcess());
        }
        return null;
    }

    @Override
    public boolean createsNewProcess() {
        return true;
    }

    @Override
    public boolean monitorRemoteProcess() {
        return this.myRunConfig.monitorRemoteProcess();
    }
}

