/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.fd.FlightRecorder;
import com.android.tools.idea.fd.InstantRunBuildAnalyzer;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.AndroidLaunchTasksProvider;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.LaunchTasksProviderFactory;
import com.android.tools.idea.run.tasks.UpdateSessionTasksProvider;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLaunchTasksProviderFactory
implements LaunchTasksProviderFactory {
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final AndroidFacet myFacet;
    private final ApplicationIdProvider myApplicationIdProvider;
    private final ApkProvider myApkProvider;
    private final DeviceFutures myDeviceFutures;
    private final LaunchOptions myLaunchOptions;
    private final ProcessHandler myPreviousSessionProcessHandler;
    private final InstantRunContext myInstantRunContext;

    public AndroidLaunchTasksProviderFactory(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider, @NotNull DeviceFutures deviceFutures, @NotNull LaunchOptions launchOptions, @Nullable ProcessHandler processHandler, @Nullable InstantRunContext instantRunContext) {
        if (runConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfig", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (applicationIdProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationIdProvider", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (deviceFutures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceFutures", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (launchOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchOptions", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myApkProvider = apkProvider;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchOptions = launchOptions;
        this.myPreviousSessionProcessHandler = processHandler;
        this.myInstantRunContext = instantRunContext;
    }

    @Override
    @NotNull
    public LaunchTasksProvider get() {
        InstantRunBuildInfo instantRunBuildInfo;
        Project project = this.myEnv.getProject();
        InstantRunStatsService.get(project).notifyDeployStarted();
        InstantRunBuildAnalyzer analyzer = null;
        InstantRunBuildInfo instantRunBuildInfo2 = instantRunBuildInfo = this.myInstantRunContext != null ? this.myInstantRunContext.getInstantRunBuildInfo() : null;
        if (instantRunBuildInfo != null) {
            analyzer = new InstantRunBuildAnalyzer(project, this.myInstantRunContext, this.myPreviousSessionProcessHandler);
            if (InstantRunSettings.isRecorderEnabled()) {
                if (!this.myDeviceFutures.getDevices().isEmpty()) {
                    FlightRecorder.get(project).setLaunchTarget(this.myDeviceFutures.getDevices().get(0));
                }
                FlightRecorder.get(project).saveBuildInfo(instantRunBuildInfo);
            }
        }
        if (analyzer != null && analyzer.canReuseProcessHandler()) {
            UpdateSessionTasksProvider updateSessionTasksProvider = new UpdateSessionTasksProvider(analyzer);
            if (updateSessionTasksProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "get"));
            }
            return updateSessionTasksProvider;
        }
        AndroidLaunchTasksProvider androidLaunchTasksProvider = new AndroidLaunchTasksProvider(this.myRunConfig, this.myEnv, this.myFacet, analyzer, this.myApplicationIdProvider, this.myApkProvider, this.myLaunchOptions);
        if (androidLaunchTasksProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "get"));
        }
        return androidLaunchTasksProvider;
    }
}

