/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDebuggerContext
implements JDOMExternalizable {
    public String DEBUGGER_TYPE;
    private final Map<String, AndroidDebuggerState> myAndroidDebuggerStates;
    private final String myDefaultDebuggerType;

    public AndroidDebuggerContext(@NotNull String defaultDebuggerType) {
        if (defaultDebuggerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultDebuggerType", "com/android/tools/idea/run/editor/AndroidDebuggerContext", "<init>"));
        }
        this.myDefaultDebuggerType = defaultDebuggerType;
        this.DEBUGGER_TYPE = this.getDefaultAndroidDebuggerType();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            builder.put((Object)androidDebugger.getId(), androidDebugger.createState());
        }
        this.myAndroidDebuggerStates = builder.build();
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        for (Map.Entry<String, AndroidDebuggerState> entry : this.myAndroidDebuggerStates.entrySet()) {
            Element optionElement = element.getChild(entry.getKey());
            if (optionElement == null) continue;
            entry.getValue().readExternal(optionElement);
        }
        if (this.getAndroidDebugger() == null) {
            this.DEBUGGER_TYPE = this.getDefaultAndroidDebuggerType();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (Map.Entry<String, AndroidDebuggerState> entry : this.myAndroidDebuggerStates.entrySet()) {
            Element optionElement = new Element(entry.getKey());
            element.addContent(optionElement);
            entry.getValue().writeExternal(optionElement);
        }
    }

    @NotNull
    public String getDebuggerType() {
        String string = this.DEBUGGER_TYPE;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidDebuggerContext", "getDebuggerType"));
        }
        return string;
    }

    public void setDebuggerType(@NotNull String debuggerType) {
        if (debuggerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerType", "com/android/tools/idea/run/editor/AndroidDebuggerContext", "setDebuggerType"));
        }
        this.DEBUGGER_TYPE = debuggerType;
    }

    @NotNull
    public List<AndroidDebugger> getAndroidDebuggers() {
        ArrayList arrayList = Lists.newArrayList((Object[])AndroidDebugger.EP_NAME.getExtensions());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidDebuggerContext", "getAndroidDebuggers"));
        }
        return arrayList;
    }

    @Nullable
    public AndroidDebugger getAndroidDebugger() {
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            if (!androidDebugger.getId().equals(this.DEBUGGER_TYPE)) continue;
            return androidDebugger;
        }
        return null;
    }

    @Nullable
    public <T extends AndroidDebuggerState> T getAndroidDebuggerState(@NotNull String androidDebuggerId) {
        if (androidDebuggerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidDebuggerId", "com/android/tools/idea/run/editor/AndroidDebuggerContext", "getAndroidDebuggerState"));
        }
        AndroidDebuggerState state = this.myAndroidDebuggerStates.get(androidDebuggerId);
        return (T)(state != null ? state : null);
    }

    @Nullable
    public <T extends AndroidDebuggerState> T getAndroidDebuggerState() {
        return this.getAndroidDebuggerState(this.DEBUGGER_TYPE);
    }

    @NotNull
    protected String getDefaultAndroidDebuggerType() {
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            if (!androidDebugger.shouldBeDefault()) continue;
            String string = androidDebugger.getId();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidDebuggerContext", "getDefaultAndroidDebuggerType"));
            }
            return string;
        }
        String string = this.myDefaultDebuggerType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/AndroidDebuggerContext", "getDefaultAndroidDebuggerType"));
        }
        return string;
    }
}

