/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.analytics;

import com.android.sdklib.devices.State;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.analytics.NopTracker;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.google.wireless.android.sdk.stats.LayoutEditorState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlUsageTrackerManager
implements NlUsageTracker {
    static final NlUsageTracker NOP_TRACKER = new NopTracker();
    private static final int LOG_RENDER_PERCENT = 10;
    private static final Cache<DesignSurface, NlUsageTracker> sTrackersCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static ExecutorService ourExecutorService = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10));
    private static final Random sRandom = new Random();
    private final Executor myExecutor;
    private final WeakReference<DesignSurface> myDesignSurfaceRef;
    private final UsageTracker myUsageTracker;

    NlUsageTrackerManager(@NotNull Executor executor, @Nullable DesignSurface surface, @NotNull UsageTracker usageTracker) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "<init>"));
        }
        if (usageTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageTracker", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "<init>"));
        }
        this.myExecutor = executor;
        this.myDesignSurfaceRef = new WeakReference<DesignSurface>(surface);
        this.myUsageTracker = usageTracker;
    }

    @NotNull
    static NlUsageTracker getInstanceInner(@Nullable DesignSurface surface) {
        NlUsageTracker nlUsageTracker;
        if (surface == null) {
            NlUsageTracker nlUsageTracker2 = NOP_TRACKER;
            if (nlUsageTracker2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "getInstanceInner"));
            }
            return nlUsageTracker2;
        }
        try {
            nlUsageTracker = (NlUsageTracker)sTrackersCache.get((Object)surface, () -> new NlUsageTrackerManager(ourExecutorService, surface, UsageTracker.getInstance()));
        }
        catch (ExecutionException e) {
            assert (false);
            NlUsageTracker nlUsageTracker3 = NOP_TRACKER;
            if (nlUsageTracker3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "getInstanceInner"));
            }
            return nlUsageTracker3;
        }
        if (nlUsageTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "getInstanceInner"));
        }
        return nlUsageTracker;
    }

    @NotNull
    public static NlUsageTracker getInstance(@Nullable DesignSurface surface) {
        NlUsageTracker nlUsageTracker = UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn() ? NlUsageTrackerManager.getInstanceInner(surface) : NOP_TRACKER;
        if (nlUsageTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "getInstance"));
        }
        return nlUsageTracker;
    }

    @NotNull
    static LayoutEditorState getState(@Nullable DesignSurface surface) {
        Configuration configuration;
        LayoutEditorState.Builder builder = LayoutEditorState.newBuilder();
        if (surface == null) {
            LayoutEditorState layoutEditorState = builder.build();
            if (layoutEditorState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "getState"));
            }
            return layoutEditorState;
        }
        builder.setMode(surface.isPreviewSurface() ? LayoutEditorState.Mode.PREVIEW_MODE : LayoutEditorState.Mode.DESIGN_MODE);
        switch (surface.getLayoutType()) {
            case DRAWABLE: {
                builder.setType(LayoutEditorState.Type.DRAWABLE);
                break;
            }
            case LAYOUT: {
                builder.setType(LayoutEditorState.Type.LAYOUT);
                break;
            }
            case MENU: {
                builder.setType(LayoutEditorState.Type.MENU);
                break;
            }
            case PREFERENCE_SCREEN: {
                builder.setType(LayoutEditorState.Type.PREFERENCE_SCREEN);
                break;
            }
        }
        double scale = surface.getScale();
        if (SystemInfo.isMac && UIUtil.isRetina()) {
            scale *= 2.0;
        }
        if ((configuration = surface.getConfiguration()) != null) {
            State deviceState = configuration.getDeviceState();
            if (deviceState != null) {
                switch (deviceState.getOrientation()) {
                    case PORTRAIT: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.PORTRAIT);
                        break;
                    }
                    case LANDSCAPE: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.LANDSCAPE);
                        break;
                    }
                }
            }
            if (configuration.getTarget() != null) {
                builder.setConfigApiLevel(configuration.getTarget().getVersion().getApiString());
            }
        }
        if (scale >= 0.0) {
            builder.setConfigZoomLevel((int)(scale * 100.0));
        }
        switch (surface.getScreenMode()) {
            case SCREEN_ONLY: {
                builder.setSurfaces(LayoutEditorState.Surfaces.SCREEN_SURFACE);
                break;
            }
            case BLUEPRINT_ONLY: {
                builder.setSurfaces(LayoutEditorState.Surfaces.BLUEPRINT_SURFACE);
                break;
            }
            case BOTH: {
                builder.setSurfaces(LayoutEditorState.Surfaces.BOTH);
            }
        }
        LayoutEditorState layoutEditorState = builder.build();
        if (layoutEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "getState"));
        }
        return layoutEditorState;
    }

    boolean shouldLog(int percent) {
        return sRandom.nextInt(100) >= 100 - percent - 1;
    }

    private void logStudioEvent(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType, @Nullable Consumer<LayoutEditorEvent.Builder> consumer) {
        if (eventType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "logStudioEvent"));
        }
        try {
            this.myExecutor.execute(() -> {
                if (eventType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "lambda$logStudioEvent$1"));
                }
                LayoutEditorEvent.Builder builder = LayoutEditorEvent.newBuilder().setType(eventType).setState(NlUsageTrackerManager.getState((DesignSurface)this.myDesignSurfaceRef.get()));
                if (consumer != null) {
                    consumer.accept(builder);
                }
                AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(builder.build());
                this.myUsageTracker.log(studioEvent);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void logAction(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "logAction"));
        }
        assert (!LayoutEditorEvent.LayoutEditorEventType.RENDER.equals((Object)eventType)) : "RENDER actions should be logged through logRenderResult";
        this.logStudioEvent(eventType, null);
    }

    @Override
    public void logRenderResult(@Nullable NlModel.ChangeType trigger, @NotNull RenderResult result, long totalRenderTimeMs) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "logRenderResult"));
        }
        if (!this.shouldLog(10)) {
            return;
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.RENDER, builder -> {
            void event;
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager", "lambda$logRenderResult$3"));
            }
            LayoutEditorRenderResult.Builder builder2 = LayoutEditorRenderResult.newBuilder().setResultCode(result.getRenderResult().getStatus().ordinal()).setTotalRenderTimeMs(totalRenderTimeMs);
            if (trigger != null) {
                switch (trigger) {
                    case RESOURCE_EDIT: 
                    case RESOURCE_CHANGED: {
                        builder2.setTrigger(LayoutEditorRenderResult.Trigger.RESOURCE_CHANGE);
                        break;
                    }
                    case EDIT: 
                    case ADD_COMPONENTS: 
                    case DELETE: 
                    case DND_COMMIT: 
                    case DND_END: 
                    case DROP: 
                    case RESIZE_END: 
                    case RESIZE_COMMIT: {
                        builder2.setTrigger(LayoutEditorRenderResult.Trigger.EDIT);
                        break;
                    }
                    case REQUEST_RENDER: {
                        builder2.setTrigger(LayoutEditorRenderResult.Trigger.USER);
                        break;
                    }
                    case BUILD: {
                        builder2.setTrigger(LayoutEditorRenderResult.Trigger.BUILD);
                        break;
                    }
                }
            }
            builder2.setComponentCount((int)result.getRootViews().stream().flatMap(s -> Stream.concat(s.getChildren().stream(), Stream.of(s))).count());
            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel(result, null);
            builder2.setTotalIssueCount(errorModel.getSize());
            if (errorModel.getSize() > 0) {
                int errorCount = 0;
                int fidelityWarningCount = 0;
                for (RenderErrorModel.Issue issue : errorModel.getIssues()) {
                    if (HighlightSeverity.ERROR.equals((Object)issue.getSeverity())) {
                        ++errorCount;
                        continue;
                    }
                    if (!issue.getSummary().startsWith("Layout fid")) continue;
                    ++fidelityWarningCount;
                }
                builder2.setErrorCount(errorCount).setFidelityWarningCount(fidelityWarningCount);
            }
            event.setRenderResult(builder2.build());
        });
    }
}

