/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.project.FeatureEnableService;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;

public class NlEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String DESIGNER_ID = "android-designer2";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/editor/NlEditorProvider", "accept"));
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, file);
        if (!(psiFile instanceof XmlFile) || AndroidFacet.getInstance((PsiElement)psiFile) == null) {
            return false;
        }
        FeatureEnableService featureEnableService = FeatureEnableService.getInstance(project);
        if (featureEnableService == null || !featureEnableService.isLayoutEditorEnabled(project)) {
            return false;
        }
        return NlLayoutType.supports((XmlFile)psiFile);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        AndroidFacet facet;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/uibuilder/editor/NlEditorProvider", "createEditor"));
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, file);
        AndroidFacet androidFacet = facet = psiFile instanceof XmlFile ? AndroidFacet.getInstance((PsiElement)psiFile) : null;
        assert (facet != null);
        NlEditor nlEditor = new NlEditor(facet, file, project);
        if (nlEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlEditorProvider", "createEditor"));
        }
        return nlEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (DESIGNER_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlEditorProvider", "getEditorTypeId"));
        }
        return DESIGNER_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor() ? FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR : FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

