/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.editor.NlActionsToolbar;
import com.android.tools.idea.uibuilder.editor.NlPreviewManager;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.palette.NlPaletteDefinition;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPreviewForm
implements Disposable,
CaretListener {
    private final NlPreviewManager myManager;
    private final DesignSurface mySurface;
    private final WorkBench<DesignSurface> myWorkBench;
    private final MergingUpdateQueue myRenderingQueue = new MergingUpdateQueue("android.layout.preview.caret", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    private boolean myUseInteractiveSelector = true;
    private boolean myIgnoreListener;
    private RenderResult myRenderResult;
    private XmlFile myFile;
    private boolean isActive = true;
    private final NlActionsToolbar myActionsToolbar;
    private XmlFile myInactiveFile;
    private Pending myPendingFile;
    private TextEditor myEditor;
    private CaretModel myCaretModel;
    private DesignSurface.ScreenMode myScreenMode;

    public NlPreviewForm(NlPreviewManager manager) {
        this.myManager = manager;
        Project project = this.myManager.getProject();
        this.mySurface = new DesignSurface(project, true);
        Disposer.register((Disposable)this, (Disposable)this.mySurface);
        this.mySurface.setCentered(true);
        this.mySurface.setScreenMode(DesignSurface.ScreenMode.SCREEN_ONLY, false);
        this.mySurface.addListener(new DesignSurfaceListener(){

            @Override
            public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
                if (surface == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlPreviewForm$1", "componentSelectionChanged"));
                }
                if (newSelection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/editor/NlPreviewForm$1", "componentSelectionChanged"));
                }
                assert (surface == NlPreviewForm.this.mySurface);
                NlComponent component = newSelection.size() == 1 ? newSelection.get(0) : null;
                NlPreviewForm.this.selectComponent(component);
            }

            @Override
            public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
                if (surface == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlPreviewForm$1", "screenChanged"));
                }
            }

            @Override
            public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
                if (surface == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlPreviewForm$1", "modelChanged"));
                }
            }

            @Override
            public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
                if (surface == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlPreviewForm$1", "activatePreferredEditor"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlPreviewForm$1", "activatePreferredEditor"));
                }
                return false;
            }
        });
        this.myRenderingQueue.setRestartTimerOnAdd(true);
        this.myActionsToolbar = new NlActionsToolbar(this.mySurface);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this.myActionsToolbar.getToolbarComponent(), "North");
        contentPanel.add((Component)this.mySurface, "Center");
        this.myWorkBench = new WorkBench(project, "Preview", null);
        this.myWorkBench.init((JComponent)contentPanel, (Object)this.mySurface, Collections.singletonList(new NlPaletteDefinition(project, Side.LEFT, Split.TOP, AutoHide.AUTO_HIDE)));
    }

    private void setEditor(@Nullable TextEditor editor) {
        if (editor != this.myEditor) {
            this.myEditor = editor;
            this.mySurface.setFileEditorDelegate((FileEditor)editor);
            if (this.myCaretModel != null) {
                this.myCaretModel.removeCaretListener((CaretListener)this);
                this.myCaretModel = null;
            }
            if (editor != null) {
                this.myCaretModel = this.myEditor.getEditor().getCaretModel();
                this.myCaretModel.addCaretListener((CaretListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectComponent(@Nullable NlComponent component) {
        int offset;
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        if (this.myEditor != null && component != null && component.getTag().isValid() && this.myUseInteractiveSelector && !this.myIgnoreListener && (offset = component.getTag().getTextOffset()) != -1) {
            Editor editor = this.myEditor.getEditor();
            this.myIgnoreListener = true;
            try {
                screenView.getSelectionModel().setSelection(Collections.singletonList(component));
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
            finally {
                this.myIgnoreListener = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaret() {
        int offset;
        ScreenView screenView;
        if (this.myCaretModel != null && !this.myIgnoreListener && this.myUseInteractiveSelector && (screenView = this.mySurface.getCurrentScreenView()) != null && (offset = this.myCaretModel.getOffset()) != -1) {
            List<NlComponent> views = screenView.getModel().findByOffset(offset);
            if (views == null || views.isEmpty()) {
                views = screenView.getModel().getComponents();
            }
            try {
                this.myIgnoreListener = true;
                SelectionModel selectionModel = screenView.getSelectionModel();
                selectionModel.setSelection(views);
                this.myRenderingQueue.queue(new Update("Preview update"){

                    public void run() {
                        NlPreviewForm.this.mySurface.repaint();
                    }

                    public boolean canEat(Update update) {
                        return true;
                    }
                });
            }
            finally {
                this.myIgnoreListener = false;
            }
        }
    }

    @Nullable
    public XmlFile getFile() {
        if (this.myFile == null && this.myPendingFile != null) {
            return this.myPendingFile.file;
        }
        return this.myFile;
    }

    @NotNull
    public JComponent getComponent() {
        WorkBench<DesignSurface> workBench = this.myWorkBench;
        if (workBench == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlPreviewForm", "getComponent"));
        }
        return workBench;
    }

    public void dispose() {
        this.deactivate();
        this.myInactiveFile = null;
    }

    public void setUseInteractiveSelector(boolean useInteractiveSelector) {
        this.myUseInteractiveSelector = useInteractiveSelector;
    }

    public boolean setFile(@Nullable PsiFile file) {
        AndroidFacet facet;
        if (!this.isActive) {
            this.myInactiveFile = (XmlFile)file;
            if (file != null) {
                return false;
            }
        }
        if (this.myPendingFile != null) {
            if (file == this.myPendingFile.file) {
                return false;
            }
            this.myPendingFile.invalidate();
            this.mySurface.setModel(null);
        } else if (file == this.myFile) {
            return false;
        }
        AndroidFacet androidFacet = facet = file instanceof XmlFile ? AndroidFacet.getInstance((PsiElement)file) : null;
        if (facet == null || file.getVirtualFile() == null) {
            this.myPendingFile = null;
            this.myFile = null;
            this.setActiveModel(null);
        } else {
            XmlFile xmlFile = (XmlFile)file;
            NlModel model = NlModel.create(this.mySurface, null, facet, xmlFile);
            this.myPendingFile = new Pending(xmlFile, model);
        }
        return true;
    }

    public void setActiveModel(@Nullable NlModel model) {
        this.myPendingFile = null;
        ScreenView currentScreenView = this.mySurface.getCurrentScreenView();
        if (currentScreenView != null) {
            currentScreenView.getModel().deactivate();
            Disposer.dispose((Disposable)currentScreenView.getModel());
        }
        if (model == null) {
            this.setEditor(null);
            this.myWorkBench.setToolContext(null);
        } else {
            this.myFile = model.getFile();
            this.mySurface.setModel(model);
            if (!this.mySurface.isCanvasResizing() && this.mySurface.isZoomFitted()) {
                this.mySurface.zoomToFit();
            } else {
                this.mySurface.updateScrolledAreaSize();
            }
            this.setEditor(this.myManager.getActiveLayoutXmlEditor());
            model.activate();
            this.myWorkBench.setToolContext((Object)this.mySurface);
            this.myWorkBench.setFileEditor((FileEditor)this.myEditor);
            this.myActionsToolbar.setModel(model);
            if (!model.getType().isSupportedByDesigner()) {
                this.myScreenMode = this.mySurface.getScreenMode();
                this.mySurface.setScreenMode(DesignSurface.ScreenMode.SCREEN_ONLY, false);
                this.myWorkBench.setMinimizePanelsVisible(false);
            } else if (this.myScreenMode != null && this.mySurface.getScreenMode() == DesignSurface.ScreenMode.SCREEN_ONLY) {
                this.mySurface.setScreenMode(this.myScreenMode, false);
                this.myWorkBench.setMinimizePanelsVisible(true);
            }
        }
    }

    @Nullable
    public RenderResult getRenderResult() {
        return this.myRenderResult;
    }

    public void setRenderResult(@NotNull RenderResult renderResult) {
        if (renderResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderResult", "com/android/tools/idea/uibuilder/editor/NlPreviewForm", "setRenderResult"));
        }
        this.myRenderResult = renderResult;
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlPreviewForm", "getSurface"));
        }
        return designSurface;
    }

    public void caretPositionChanged(CaretEvent e) {
        if (!this.myIgnoreListener) {
            this.updateCaret();
        }
    }

    public void activate() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        if (this.myFile == null && this.myPendingFile == null) {
            this.setFile((PsiFile)this.myInactiveFile);
        }
        this.myInactiveFile = null;
    }

    public void deactivate() {
        if (!this.isActive) {
            return;
        }
        this.myInactiveFile = this.myFile != null ? this.myFile : (this.myPendingFile != null ? this.myPendingFile.file : null);
        this.setFile(null);
        this.isActive = false;
    }

    private class Pending
    implements ModelListener,
    Runnable {
        public final XmlFile file;
        public final NlModel model;
        public boolean valid = true;

        public Pending(XmlFile file, NlModel model) {
            this.file = file;
            this.model = model;
            model.addListener(this);
            model.requestRender();
        }

        @Override
        public void modelChanged(@NotNull NlModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/editor/NlPreviewForm$Pending", "modelChanged"));
            }
            model.render();
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/editor/NlPreviewForm$Pending", "modelChangedOnLayout"));
            }
        }

        @Override
        public void modelRendered(@NotNull NlModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/editor/NlPreviewForm$Pending", "modelRendered"));
            }
            model.removeListener(this);
            if (this.valid) {
                this.valid = false;
                ApplicationManager.getApplication().invokeLater((Runnable)this, model.getProject().getDisposed());
            }
        }

        public void invalidate() {
            this.valid = false;
        }

        @Override
        public void run() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            NlPreviewForm.this.setActiveModel(this.model);
        }
    }
}

