/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.uibuilder.api.DefaultResizeHandler;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SegmentType;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbsoluteLayoutHandler
extends ViewGroupHandler {
    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler", "createDragHandler"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler", "createDragHandler"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler", "createDragHandler"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler", "createDragHandler"));
        }
        return new DragHandler(editor, this, layout, components, type){

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                if (graphics == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$1", "paint"));
                }
                int deltaX = this.lastX - this.startX;
                int deltaY = this.lastY - this.startY;
                for (NlComponent component : this.components) {
                    int x = component.x + deltaX;
                    int y = component.y + deltaY;
                    int w = component.w;
                    int h = component.h;
                    graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
                    graphics.drawRect(x, y, w, h);
                }
            }

            @Override
            public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
                if (insertType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$1", "commit"));
                }
                int deltaX = x - this.startX;
                int deltaY = y - this.startY;
                for (NlComponent component : this.components) {
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_x", this.editor.pxToDpWithUnits(component.x - this.layout.x + deltaX));
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_y", this.editor.pxToDpWithUnits(component.y - this.layout.y + deltaY));
                }
                this.insertComponents(-1, insertType);
            }
        };
    }

    @Override
    @Nullable
    public ResizeHandler createResizeHandler(@NotNull ViewEditor editor, @NotNull NlComponent component, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler", "createResizeHandler"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler", "createResizeHandler"));
        }
        return new DefaultResizeHandler(editor, this, component, horizontalEdgeType, verticalEdgeType){

            @Override
            protected void setNewSizeBounds(@NotNull NlComponent component, @NotNull NlComponent layout, @NotNull Rectangle oldBounds, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$2", "setNewSizeBounds"));
                }
                if (layout == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$2", "setNewSizeBounds"));
                }
                if (oldBounds == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBounds", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$2", "setNewSizeBounds"));
                }
                if (newBounds == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBounds", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$2", "setNewSizeBounds"));
                }
                Rectangle previousBounds = new Rectangle(component.x, component.y, component.w, component.h);
                super.setNewSizeBounds(component, layout, previousBounds, newBounds, horizontalEdge, verticalEdge);
                if (verticalEdge != null && newBounds.x != previousBounds.x) {
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_x", String.format("%ddp", this.editor.pxToDp(newBounds.x - layout.x)));
                }
                if (horizontalEdge != null && newBounds.y != previousBounds.y) {
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_y", String.format("%ddp", this.editor.pxToDp(newBounds.y - layout.y)));
                }
            }

            @Override
            protected String getResizeUpdateMessage(@NotNull NlComponent child, @NotNull NlComponent parent, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$2", "getResizeUpdateMessage"));
                }
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$2", "getResizeUpdateMessage"));
                }
                if (newBounds == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBounds", "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$2", "getResizeUpdateMessage"));
                }
                Rectangle parentBounds = new Rectangle(this.layout.x, this.layout.y, this.layout.w, this.layout.h);
                if (horizontalEdge == SegmentType.BOTTOM && verticalEdge == SegmentType.RIGHT) {
                    return super.getResizeUpdateMessage(child, parent, newBounds, horizontalEdge, verticalEdge);
                }
                return String.format("x=%d, y=%d\nwidth=%s, height=%s", this.editor.pxToDp(newBounds.x - parentBounds.x), this.editor.pxToDp(newBounds.y - parentBounds.y), this.getWidthAttribute(), this.getHeightAttribute());
            }
        };
    }
}

