/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.ide.common.rendering.api.ViewInfo;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ViewInfoUtils {
    private ViewInfoUtils() {
    }

    @Nullable
    static ViewInfo findListView(@NotNull Collection<ViewInfo> rootViews) {
        if (rootViews == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootViews", "com/android/tools/idea/uibuilder/handlers/preference/ViewInfoUtils", "findListView"));
        }
        Optional<ViewInfo> listView = rootViews.stream().map(rootView -> ViewInfoUtils.findViewWithName(rootView, "android.widget.ListView")).filter(Objects::nonNull).findFirst();
        return listView.orElse(null);
    }

    @Nullable
    private static ViewInfo findViewWithName(@NotNull ViewInfo parent, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/handlers/preference/ViewInfoUtils", "findViewWithName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/handlers/preference/ViewInfoUtils", "findViewWithName"));
        }
        if (parent.getClassName().equals(name)) {
            return parent;
        }
        Optional<ViewInfo> view = parent.getChildren().stream().map(child -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/handlers/preference/ViewInfoUtils", "lambda$findViewWithName$1"));
            }
            return ViewInfoUtils.findViewWithName(child, name);
        }).filter(Objects::nonNull).findFirst();
        return view.orElse(null);
    }
}

