/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators.forms;

import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ValueResourceNameValidator;
import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.mockup.backgroundremove.RemoveBackgroundPanel;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ToolRootPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class ExtractBackgroundForm {
    private static final Logger LOGGER = Logger.getInstance(ExtractBackgroundForm.class);
    private JButton myOKButton;
    private JButton myDismissButton;
    private RemoveBackgroundPanel myRemoveBackgroundPanel;
    private JPanel myComponent;
    private JTextField myDrawableName;
    private JBLabel myErrorLabel;
    private JPanel myUndoRedoPanel;
    private ActionListener myListener;

    public ExtractBackgroundForm(@NotNull RemoveBackgroundPanel removeBackgroundPanel) {
        if (removeBackgroundPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removeBackgroundPanel", "com/android/tools/idea/uibuilder/mockup/editor/creators/forms/ExtractBackgroundForm", "<init>"));
        }
        this.myRemoveBackgroundPanel = removeBackgroundPanel;
        this.$$$setupUI$$$();
        this.myComponent.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        this.myComponent.setFocusable(true);
        this.myComponent.repaint();
        this.myDismissButton.addActionListener(e -> this.myComponent.getParent().remove(this.myComponent));
        this.myComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!ExtractBackgroundForm.this.myDrawableName.hasFocus()) {
                    ExtractBackgroundForm.this.myComponent.requestFocusInWindow();
                }
            }
        });
        this.myDrawableName.getDocument().addDocumentListener(this.createDrawableNameListener());
        JComponent undoRedoButtons = this.createUndoRedoButtons();
        undoRedoButtons.setOpaque(false);
        this.myUndoRedoPanel.add((Component)undoRedoButtons, "South");
        this.validateDrawableName(this.myDrawableName.getDocument());
    }

    @NotNull
    private DocumentListener createDrawableNameListener() {
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExtractBackgroundForm.this.myOKButton.setEnabled(ExtractBackgroundForm.this.validateDrawableName(e.getDocument()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExtractBackgroundForm.this.myOKButton.setEnabled(ExtractBackgroundForm.this.validateDrawableName(e.getDocument()));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        if (documentListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/forms/ExtractBackgroundForm", "createDrawableNameListener"));
        }
        return documentListener;
    }

    private JComponent createUndoRedoButtons() {
        return ActionManager.getInstance().createActionToolbar("AndroidExtractBackgroundUndoRedo", (ActionGroup)new DefaultActionGroup(new AnAction[]{new AnAction("Undo", "Undo", AllIcons.Actions.Undo){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(ExtractBackgroundForm.this.myRemoveBackgroundPanel.canUndo());
            }

            public void actionPerformed(AnActionEvent e) {
                ExtractBackgroundForm.this.myRemoveBackgroundPanel.undo();
            }
        }, new AnAction("Redo", "Redo", AllIcons.Actions.Redo){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(ExtractBackgroundForm.this.myRemoveBackgroundPanel.canRedo());
            }

            public void actionPerformed(AnActionEvent e) {
                ExtractBackgroundForm.this.myRemoveBackgroundPanel.redo();
            }
        }}), true).getComponent();
    }

    private boolean validateDrawableName(Document document) {
        if (document.getLength() <= 0) {
            this.myErrorLabel.setForeground(JBColor.foreground());
            this.myErrorLabel.setText("To create the drawable, enter a name");
            return false;
        }
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        try {
            String text = document.getText(0, document.getLength());
            try {
                ValueResourceNameValidator.validate((String)text, (ResourceType)ResourceType.DRAWABLE, null);
                this.myErrorLabel.setText("");
                return true;
            }
            catch (MergingException ex) {
                this.myErrorLabel.setText(String.format("<html> %s </html>", ValueResourceNameValidator.getErrorText((String)text, (ResourceType)ResourceType.DRAWABLE)));
                return false;
            }
        }
        catch (BadLocationException ex) {
            LOGGER.warn((Throwable)ex);
            return false;
        }
    }

    public void setOKListener(ActionListener listener) {
        if (this.myListener != null) {
            this.myOKButton.removeActionListener(this.myListener);
        }
        this.myListener = listener;
        this.myOKButton.addActionListener(this.myListener);
    }

    public void setErrorText(String errorMessage) {
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        this.myErrorLabel.setText(String.format("<html>%s</html>", errorMessage));
    }

    public JPanel getComponent() {
        return this.myComponent;
    }

    @NotNull
    public String getDrawableName() {
        String string = this.myDrawableName.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/forms/ExtractBackgroundForm", "getDrawableName"));
        }
        return string;
    }

    private void createUIComponents() {
        this.myComponent = new ToolRootPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JTextField jTextField;
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        this.createUIComponents();
        JPanel jPanel2 = this.myComponent;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 5, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setOpaque(false);
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 6, 0, 0, 3, null, null, null));
        this.myOKButton = jButton2 = new JButton();
        ((Component)jButton2).setEnabled(false);
        jButton2.setOpaque(false);
        jButton2.setText("OK");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDismissButton = jButton = new JButton();
        jButton.setOpaque(false);
        jButton.setText("Dismiss");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUndoRedoPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setOpaque(false);
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 6, 0, 3, 3, null, null, null));
        RemoveBackgroundPanel removeBackgroundPanel = this.myRemoveBackgroundPanel;
        removeBackgroundPanel.setOpaque(false);
        jPanel2.add((Component)removeBackgroundPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 5, 0), -1, -1, false, false));
        jPanel4.setOpaque(false);
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        jLabel.setText("<html> Click and drag to select areas to remove <br/>(hold shift to remove all the selected color) </html>");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setOpaque(false);
        jLabel2.setText("Drawable name:");
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDrawableName = jTextField = new JTextField();
        jTextField.setOpaque(false);
        jPanel4.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jBLabel.setOpaque(false);
        jPanel4.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 0, null, new Dimension(0, 29), null));
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOpaque(false);
        jPanel4.add((Component)jSeparator, new GridConstraints(3, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jSeparator2.setOpaque(false);
        jPanel4.add((Component)jSeparator2, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator3 = new JSeparator();
        jSeparator3.setOpaque(false);
        jPanel2.add((Component)jSeparator3, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }
}

