/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import android.view.View;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.uibuilder.model.LayoutParamsManager;
import com.android.tools.idea.uibuilder.model.NlAttributesHolder;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributesTransaction
implements NlAttributesHolder {
    private final NlComponent myComponent;
    private final ReentrantReadWriteLock myLock;
    private final HashMap<String, PendingAttribute> myPendingAttributes;
    private final HashMap<String, String> myOriginalValues;
    private final NlModel myModel;
    private boolean isValid;
    private boolean isSuccessful;
    @NotNull
    private WeakReference<View> myCachedView;
    private boolean hasPendingRelayout;

    public AttributesTransaction(@NotNull NlComponent thisComponent) {
        if (thisComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisComponent", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "<init>"));
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myPendingAttributes = new HashMap();
        this.isValid = true;
        this.isSuccessful = false;
        this.myCachedView = new WeakReference<Object>(null);
        this.myComponent = thisComponent;
        this.myModel = this.myComponent.getModel();
        List<AttributeSnapshot> attributes = this.myComponent.getAttributes();
        this.myOriginalValues = Maps.newHashMapWithExpectedSize((int)attributes.size());
        attributes.stream().forEach(attribute -> this.myOriginalValues.put(AttributesTransaction.attributeKey(attribute.namespace, attribute.name), attribute.value));
    }

    @NotNull
    private static String attributeKey(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "attributeKey"));
        }
        String string = String.format("%s:%s", namespace, attribute);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "attributeKey"));
        }
        return string;
    }

    private void applyAttributeToView(@NotNull PendingAttribute attribute, @NotNull ViewInfo viewInfo, NlModel model) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "applyAttributeToView"));
        }
        if (viewInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewInfo", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "applyAttributeToView"));
        }
        if (attribute.name.startsWith("layout_")) {
            String value = attribute.value;
            Object layoutParams = viewInfo.getLayoutParamsObject();
            Object viewObject = viewInfo.getViewObject();
            if (viewObject == null || layoutParams == null) {
                return;
            }
            boolean changed = LayoutParamsManager.setAttribute(layoutParams, StringUtil.trimStart((String)attribute.name, (String)"layout_"), value, model);
            this.hasPendingRelayout |= changed;
        }
    }

    private static void triggerViewRelayout(@NotNull View view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "triggerViewRelayout"));
        }
        view.setLayoutParams(view.getLayoutParams());
    }

    private void applyAllPendingAttributesToView(@NotNull ViewInfo viewInfo) {
        if (viewInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewInfo", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "applyAllPendingAttributesToView"));
        }
        View cachedView = (View)viewInfo.getViewObject();
        this.myCachedView = new WeakReference<View>(cachedView);
        if (cachedView != null) {
            this.myPendingAttributes.values().stream().filter(Objects::nonNull).forEach(pendingAttribute -> {
                if (viewInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewInfo", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "lambda$applyAllPendingAttributesToView$1"));
                }
                this.applyAttributeToView((PendingAttribute)pendingAttribute, viewInfo, this.myModel);
            });
            this.hasPendingRelayout = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String name, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "setAttribute"));
        }
        this.myLock.writeLock().lock();
        try {
            assert (this.isValid);
            String key = AttributesTransaction.attributeKey(namespace, name);
            PendingAttribute attribute = this.myPendingAttributes.get(key);
            boolean modified = true;
            if (attribute != null) {
                if (StringUtil.equals((CharSequence)attribute.value, (CharSequence)value)) {
                    modified = false;
                } else {
                    attribute.value = value;
                }
            } else {
                attribute = new PendingAttribute(namespace, name, value);
                this.myPendingAttributes.put(key, attribute);
            }
            ViewInfo viewInfo = this.myComponent.viewInfo;
            if (viewInfo != null) {
                View cachedView = (View)this.myCachedView.get();
                if (cachedView == viewInfo.getViewObject()) {
                    if (modified && cachedView != null) {
                        this.applyAttributeToView(attribute, viewInfo, this.myModel);
                    }
                } else {
                    this.applyAllPendingAttributesToView(viewInfo);
                }
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/model/AttributesTransaction", "getAttribute"));
        }
        this.myLock.readLock().lock();
        try {
            assert (this.isValid);
            PendingAttribute pendingAttribute = this.myPendingAttributes.get(AttributesTransaction.attributeKey(namespace, attribute));
            if (pendingAttribute != null) {
                String string = pendingAttribute.value;
                return string;
            }
            String string = this.myComponent.getAttribute(namespace, attribute);
            return string;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private boolean finishTransaction() {
        assert (this.isValid);
        this.isValid = false;
        this.myComponent.myCurrentTransaction = null;
        boolean hadPendingChanges = !this.myPendingAttributes.isEmpty();
        this.myPendingAttributes.clear();
        this.myOriginalValues.clear();
        return hadPendingChanges;
    }

    public void apply() {
        ViewInfo viewInfo = this.myComponent.viewInfo;
        if (this.hasPendingRelayout && viewInfo != null) {
            View currentView = (View)viewInfo.getViewObject();
            if (currentView != this.myCachedView.get()) {
                this.applyAllPendingAttributesToView(this.myComponent.viewInfo);
            }
            AttributesTransaction.triggerViewRelayout((View)this.myComponent.viewInfo.getViewObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() {
        ViewInfo viewInfo = this.myComponent.viewInfo;
        if (this.hasPendingRelayout && viewInfo != null) {
            View currentView = (View)viewInfo.getViewObject();
            if (currentView != this.myCachedView.get()) {
                this.applyAllPendingAttributesToView(this.myComponent.viewInfo);
            }
            AttributesTransaction.triggerViewRelayout((View)this.myComponent.viewInfo.getViewObject());
        }
        this.myLock.writeLock().lock();
        try {
            assert (this.isValid);
            if (!this.myComponent.getTag().isValid()) {
                boolean currentView = this.finishTransaction();
                return currentView;
            }
            if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                boolean currentView = (Boolean)ApplicationManager.getApplication().runWriteAction(this::commit);
                return currentView;
            }
            boolean modified = false;
            for (PendingAttribute attribute : this.myPendingAttributes.values()) {
                String originalValue = this.myOriginalValues.get(AttributesTransaction.attributeKey(attribute.namespace, attribute.name));
                String currentValue = this.myComponent.getAttribute(attribute.namespace, attribute.name);
                if (StringUtil.equals((CharSequence)currentValue, (CharSequence)attribute.value) || !StringUtil.equals((CharSequence)originalValue, (CharSequence)currentValue) && (StringUtil.isEmpty((String)attribute.value) || StringUtil.equals((CharSequence)originalValue, (CharSequence)attribute.value))) continue;
                modified = true;
                this.myComponent.setAttribute(attribute.namespace, attribute.name, attribute.value);
            }
            this.isSuccessful = true;
            this.finishTransaction();
            boolean bl = modified;
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public boolean isComplete() {
        return !this.isValid;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public boolean rollback() {
        this.myLock.writeLock().lock();
        try {
            boolean bl = this.finishTransaction();
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    private static class PendingAttribute {
        final String namespace;
        final String name;
        String value;

        private PendingAttribute(@Nullable String namespace, @NotNull String name, @Nullable String value) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/model/AttributesTransaction$PendingAttribute", "<init>"));
            }
            this.namespace = namespace;
            this.name = name;
            this.value = value;
        }
    }
}

