/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.splitter.ComponentsSplitter;
import com.android.tools.adtui.splitter.SplitterUtil;
import com.android.tools.adtui.treegrid.TreeGrid;
import com.android.tools.idea.uibuilder.analytics.NlUsageTrackerManager;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.ItemTransferHandler;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PaletteMode;
import com.android.tools.idea.uibuilder.palette.SelectionListener;
import com.android.tools.idea.uibuilder.palette.SingleListTreeProvider;
import com.android.tools.idea.uibuilder.palette.TreeCategoryProvider;
import com.android.tools.idea.uibuilder.palette.TreeProvider;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPaletteTreeGrid
extends JPanel
implements Disposable {
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 20;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 40;
    private final Project myProject;
    private final DependencyManager myDependencyManager;
    private final Runnable myCloseAutoHideCallback;
    private final JList<Palette.Group> myCategoryList;
    private final TreeGrid<Palette.Item> myTree;
    private final MyFilter myFilter;
    private final IconPreviewFactory myIconPreviewFactory;
    private PaletteMode myMode;
    private SelectionListener myListener;
    private DesignSurface mySurface;
    private Palette myPalette;

    public NlPaletteTreeGrid(@NotNull Project project, @NotNull DependencyManager dependencyManager, @NotNull Runnable closeAutoHideCallback, @Nullable DesignSurface designSurface, @NotNull IconPreviewFactory iconFactory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "<init>"));
        }
        if (dependencyManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyManager", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "<init>"));
        }
        if (closeAutoHideCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeAutoHideCallback", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "<init>"));
        }
        if (iconFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconFactory", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "<init>"));
        }
        this.myProject = project;
        this.myDependencyManager = dependencyManager;
        this.myCloseAutoHideCallback = closeAutoHideCallback;
        this.mySurface = designSurface;
        this.myMode = PaletteMode.ICON_AND_NAME;
        this.myIconPreviewFactory = iconFactory;
        this.myTree = new TreeGrid();
        this.myCategoryList = new JBList();
        this.myCategoryList.setBackground(UIUtil.getPanelBackground());
        this.myCategoryList.setForeground(UIManager.getColor("Panel.foreground"));
        this.myCategoryList.addListSelectionListener(this::categorySelectionChanged);
        this.myCategoryList.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.myFilter = new MyFilter(this.myCategoryList);
        JScrollPane categoryPane = ScrollPaneFactory.createScrollPane(this.myCategoryList, (int)20, (int)31);
        categoryPane.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane paletteScrollPane = ScrollPaneFactory.createScrollPane(this.myTree, (int)20, (int)31);
        paletteScrollPane.setBorder(BorderFactory.createEmptyBorder());
        paletteScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        paletteScrollPane.getVerticalScrollBar().setBlockIncrement(40);
        ComponentsSplitter palette = new ComponentsSplitter(false, true);
        palette.setFirstComponent((JComponent)categoryPane);
        palette.setInnerComponent((JComponent)paletteScrollPane);
        palette.setHonorComponentsMinimumSize(true);
        palette.setFirstSize(JBUI.scale((int)100));
        SplitterUtil.setMinimumWidth((JComponent)categoryPane, (int)20);
        SplitterUtil.setMinimumWidth((JComponent)paletteScrollPane, (int)20);
        Disposer.register((Disposable)this, (Disposable)palette);
        this.setLayout(new BorderLayout());
        this.add((Component)palette, "Center");
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy(this.myCategoryList, this.myTree));
    }

    @Override
    public void requestFocus() {
        NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.SHOW_PALETTE);
        this.myTree.requestFocus();
    }

    @NotNull
    public PaletteMode getMode() {
        PaletteMode paletteMode = this.myMode;
        if (paletteMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "getMode"));
        }
        return paletteMode;
    }

    public void setMode(@NotNull PaletteMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "setMode"));
        }
        this.myMode = mode;
        int fixedCellWidth = -1;
        int fixedCellHeight = -1;
        int border = JBUI.scale((int)mode.getBorder());
        int orientation = 2;
        switch (mode) {
            case ICON_AND_NAME: {
                orientation = 0;
                break;
            }
            case LARGE_ICONS: {
                fixedCellWidth = fixedCellHeight = border + JBUI.scale((int)24) + border;
                break;
            }
            case SMALL_ICONS: {
                fixedCellWidth = fixedCellHeight = border + JBUI.scale((int)16) + border;
            }
        }
        this.myTree.setFixedCellWidth(fixedCellWidth);
        this.myTree.setFixedCellHeight(fixedCellHeight);
        this.myTree.setLayoutOrientation(orientation);
        this.myTree.setCellRenderer((ListCellRenderer)((Object)new MyCellRenderer(this.myDependencyManager, mode)));
    }

    public void populateUiModel(@NotNull Palette palette, @NotNull DesignSurface designSurface) {
        if (palette == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "palette", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "populateUiModel"));
        }
        if (designSurface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designSurface", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "populateUiModel"));
        }
        this.mySurface = designSurface;
        this.myPalette = palette;
        this.myCategoryList.setModel(new TreeCategoryProvider(palette));
        this.updateTreeModel();
    }

    private void updateTreeModel() {
        AbstractTreeStructure provider = this.myCategoryList.getModel().getSize() > 1 && this.myFilter.getPattern().isEmpty() ? new TreeProvider(this.myProject, this.myPalette) : new SingleListTreeProvider(this.myProject, this.myPalette);
        this.myTree.setModel(provider);
        this.myTree.addMouseListener(this.createMouseListenerForLoadMissingDependency());
        this.myTree.addListSelectionListener(event -> this.fireSelectionChanged((Palette.Item)this.myTree.getSelectedElement()));
        this.myTree.setVisibleSection((Object)this.myCategoryList.getSelectedValue());
        this.myTree.setTransferHandler((TransferHandler)new MyItemTransferHandler(this.mySurface, this::getSelectedItem, this.myIconPreviewFactory));
        this.setMode(this.myMode);
    }

    public void setFilter(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "setFilter"));
        }
        String oldPattern = this.myFilter.getPattern();
        this.myFilter.setPattern(pattern);
        if (pattern.isEmpty()) {
            if (!oldPattern.isEmpty()) {
                this.updateTreeModel();
            }
            this.myTree.setFilter(null);
        } else {
            if (oldPattern.isEmpty()) {
                this.updateTreeModel();
            }
            this.myTree.setFilter((Condition)this.myFilter);
            this.myTree.selectIfUnique();
        }
    }

    @NotNull
    public String getFilter() {
        String string = this.myFilter.getPattern();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "getFilter"));
        }
        return string;
    }

    private void categorySelectionChanged(@NotNull ListSelectionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "categorySelectionChanged"));
        }
        this.myTree.setVisibleSection((Object)this.myCategoryList.getSelectedValue());
        if (!this.myFilter.getPattern().isEmpty()) {
            this.setFilter(this.myFilter.getPattern());
        }
    }

    @NotNull
    protected MouseListener createMouseListenerForLoadMissingDependency() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Palette.Item item = NlPaletteTreeGrid.this.getSelectedItem();
                if (item != null && NlPaletteTreeGrid.this.myDependencyManager.needsLibraryLoad(item) && !NlPaletteTreeGrid.this.myDependencyManager.ensureLibraryIsIncluded(item)) {
                    NlPaletteTreeGrid.this.clearSelection();
                }
            }
        };
        if (mouseAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "createMouseListenerForLoadMissingDependency"));
        }
        return mouseAdapter;
    }

    public void setSelectionListener(@NotNull SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "setSelectionListener"));
        }
        this.myListener = listener;
    }

    public void fireSelectionChanged(@Nullable Palette.Item item) {
        if (this.myListener != null) {
            this.myListener.selectionChanged(item);
        }
    }

    @Nullable
    public Palette.Item getSelectedItem() {
        return (Palette.Item)this.myTree.getSelectedElement();
    }

    private void clearSelection() {
        this.myTree.setSelectedElement(null);
    }

    @NotNull
    public JList<Palette.Group> getCategoryList() {
        JList<Palette.Group> jList = this.myCategoryList;
        if (jList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "getCategoryList"));
        }
        return jList;
    }

    @NotNull
    public TreeGrid<Palette.Item> getComponentTree() {
        TreeGrid<Palette.Item> treeGrid = this.myTree;
        if (treeGrid == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid", "getComponentTree"));
        }
        return treeGrid;
    }

    public void dispose() {
    }

    private static class MyFilter
    implements Condition<Palette.Item> {
        private final SpeedSearchComparator myComparator;
        private final JList<Palette.Group> myCategoryList;
        private String myPattern;

        public MyFilter(@NotNull JList<Palette.Group> categoryList) {
            if (categoryList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryList", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFilter", "<init>"));
            }
            this.myCategoryList = categoryList;
            this.myComparator = new SpeedSearchComparator(false);
            this.myPattern = "";
        }

        public void setPattern(@NotNull String filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFilter", "setPattern"));
            }
            this.myPattern = filter;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFilter", "getPattern"));
            }
            return string;
        }

        public boolean value(@NotNull Palette.Item item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFilter", "value"));
            }
            Palette.Group group = this.myCategoryList.getSelectedValue();
            if (group != null && group != TreeCategoryProvider.ALL && group != item.getParent()) {
                return false;
            }
            return this.myComparator.matchingFragments(this.myPattern, item.getTitle()) != null;
        }
    }

    private static class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private final JList<Palette.Group> myCategoryList;
        private final TreeGrid<Palette.Item> myTree;

        private MyFocusTraversalPolicy(@NotNull JList<Palette.Group> categoryList, @NotNull TreeGrid<Palette.Item> tree) {
            if (categoryList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryList", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFocusTraversalPolicy", "<init>"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFocusTraversalPolicy", "<init>"));
            }
            this.myCategoryList = categoryList;
            this.myTree = tree;
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            return this.getOtherComponent(component);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            return this.getOtherComponent(component);
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.getTreeComponent();
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.myCategoryList;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.getTreeComponent();
        }

        @NotNull
        private Component getOtherComponent(Component component) {
            if (component != null && SwingUtilities.isDescendingFrom(component, this.myTree)) {
                JList<Palette.Group> jList = this.myCategoryList;
                if (jList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFocusTraversalPolicy", "getOtherComponent"));
                }
                return jList;
            }
            Component component2 = this.getTreeComponent();
            if (component2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFocusTraversalPolicy", "getOtherComponent"));
            }
            return component2;
        }

        @NotNull
        private Component getTreeComponent() {
            JComponent component = this.myTree.getFocusRecipient();
            if (component != null) {
                JComponent jComponent = component;
                if (jComponent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFocusTraversalPolicy", "getTreeComponent"));
                }
                return jComponent;
            }
            TreeGrid<Palette.Item> treeGrid = this.myTree;
            if (treeGrid == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFocusTraversalPolicy", "getTreeComponent"));
            }
            return treeGrid;
        }
    }

    private static class MyCellRenderer
    extends ColoredListCellRenderer<Palette.Item> {
        private final DependencyManager myDependencyManager;
        private final PaletteMode myMode;

        private MyCellRenderer(@NotNull DependencyManager dependencyManager, @NotNull PaletteMode mode) {
            if (dependencyManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyManager", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyCellRenderer", "<init>"));
            }
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyCellRenderer", "<init>"));
            }
            this.myDependencyManager = dependencyManager;
            this.myMode = mode;
            int padding = mode.getBorder();
            this.setIpad((Insets)new JBInsets(padding, Math.max(4, padding), padding, padding));
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        protected void customizeCellRenderer(@NotNull JList list, @NotNull Palette.Item item, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyCellRenderer", "customizeCellRenderer"));
            }
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyCellRenderer", "customizeCellRenderer"));
            }
            switch (this.myMode) {
                case ICON_AND_NAME: {
                    this.setIcon(this.myDependencyManager.createItemIcon(item, list));
                    this.append(item.getTitle());
                    break;
                }
                case LARGE_ICONS: {
                    this.setIcon(this.myDependencyManager.createLargeItemIcon(item, list));
                    break;
                }
                case SMALL_ICONS: {
                    this.setIcon(this.myDependencyManager.createItemIcon(item, list));
                }
            }
        }
    }

    private class MyItemTransferHandler
    extends ItemTransferHandler {
        public MyItemTransferHandler(@NotNull DesignSurface designSurface, @NotNull Supplier<Palette.Item> itemSupplier, IconPreviewFactory iconPreviewFactory) {
            if (designSurface == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designSurface", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyItemTransferHandler", "<init>"));
            }
            if (itemSupplier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemSupplier", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyItemTransferHandler", "<init>"));
            }
            if (iconPreviewFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconPreviewFactory", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyItemTransferHandler", "<init>"));
            }
            super(designSurface, itemSupplier, iconPreviewFactory);
        }

        @Override
        protected Transferable createTransferable(@NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyItemTransferHandler", "createTransferable"));
            }
            Transferable transferable = super.createTransferable(component);
            NlPaletteTreeGrid.this.myCloseAutoHideCallback.run();
            return transferable;
        }
    }
}

