/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.renderer.NlBooleanRenderer;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlBooleanEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private final JPanel myPanel;
    private final ThreeStateCheckBox myCheckbox;
    private final BrowsePanel myBrowsePanel;
    private NlProperty myProperty;
    private Object myValue;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        BrowsePanel browsePanel = new BrowsePanel(cellEditor, true);
        cellEditor.init(new NlBooleanEditor(cellEditor, browsePanel));
        return cellEditor;
    }

    public static NlBooleanEditor createForInspector(@NotNull NlEditingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/editors/NlBooleanEditor", "createForInspector"));
        }
        return new NlBooleanEditor(listener, null);
    }

    private NlBooleanEditor(@NotNull NlEditingListener listener, @Nullable BrowsePanel browsePanel) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/editors/NlBooleanEditor", "<init>"));
        }
        super(listener);
        this.myCheckbox = new ThreeStateCheckBox();
        this.myCheckbox.addActionListener(this::checkboxChanged);
        this.myPanel = new JPanel(new BorderLayout(HORIZONTAL_COMPONENT_GAP, 0));
        this.myPanel.add((Component)this.myCheckbox, "Before");
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.myBrowsePanel = browsePanel;
        if (browsePanel != null) {
            this.myPanel.add((Component)browsePanel, "After");
        }
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/NlBooleanEditor", "setProperty"));
        }
        this.myProperty = property;
        String propValue = this.myProperty.getValue();
        this.myValue = propValue;
        ThreeStateCheckBox.State state = NlBooleanRenderer.getState(propValue);
        this.myCheckbox.setState(state == null ? ThreeStateCheckBox.State.NOT_SELECTED : state);
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setProperty(property);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlBooleanEditor", "getComponent"));
        }
        return jPanel;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public void activate() {
        this.myValue = NlBooleanRenderer.getNextState(this.myCheckbox.getState());
        this.stopEditing(this.myValue);
    }

    private void checkboxChanged(ActionEvent e) {
        this.myValue = NlBooleanRenderer.getBoolean(this.myCheckbox.getState());
        this.stopEditing(this.myValue);
    }
}

