/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.IdAnalyzer;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdEnumSupport
extends EnumSupport {
    private final IdAnalyzer myIdAnalyzer;

    public IdEnumSupport(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/IdEnumSupport", "<init>"));
        }
        this(property, new IdAnalyzer(property));
    }

    public IdEnumSupport(@NotNull NlProperty property, @NotNull IdAnalyzer analyzer) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/IdEnumSupport", "<init>"));
        }
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "com/android/tools/idea/uibuilder/property/editors/support/IdEnumSupport", "<init>"));
        }
        super(property);
        this.myIdAnalyzer = analyzer;
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        List<ValueWithDisplayString> list = this.myIdAnalyzer.findIds().stream().map(id -> new ValueWithDisplayString((String)id, "@+id/" + id)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/IdEnumSupport", "getAllValues"));
        }
        return list;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value, @Nullable String hint) {
        if (resolvedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedValue", "com/android/tools/idea/uibuilder/property/editors/support/IdEnumSupport", "createFromResolvedValue"));
        }
        if (value != null && !value.startsWith("@+id/") && !value.startsWith("@id/")) {
            value = "@+id/" + value;
        }
        String display = resolvedValue;
        display = StringUtil.trimStart((String)display, (String)"@id/");
        display = StringUtil.trimStart((String)display, (String)"@+id/");
        ValueWithDisplayString valueWithDisplayString = new ValueWithDisplayString(display, value, hint);
        if (valueWithDisplayString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/IdEnumSupport", "createFromResolvedValue"));
        }
        return valueWithDisplayString;
    }
}

