/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.decorator.ButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.CheckBoxDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ConstraintLayoutDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ImageViewDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ProgressBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.RadioButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SeekBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SwitchDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.TextViewDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawComponentBackground;
import com.android.tools.idea.uibuilder.scene.draw.DrawComponentFrame;
import com.android.tools.idea.uibuilder.scene.target.Target;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SceneDecorator {
    private static final boolean DEBUG = false;
    static SceneDecorator basicDecorator = new SceneDecorator();
    static Map<String, Constructor<? extends SceneDecorator>> ourConstructorMap = new HashMap<String, Constructor<? extends SceneDecorator>>();
    static Map<String, SceneDecorator> ourSceneMap = new HashMap<String, SceneDecorator>();

    public static SceneDecorator get(NlComponent component) {
        String parentTag;
        String tag = component.getTagName();
        if (tag != null && tag.equalsIgnoreCase("merge") && (parentTag = component.getAttribute("http://schemas.android.com/tools", "parentTag")) != null) {
            tag = parentTag;
        }
        if (ourConstructorMap.containsKey(tag)) {
            if (!ourSceneMap.containsKey(tag)) {
                try {
                    ourSceneMap.put(tag, ourConstructorMap.get(tag).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    ourSceneMap.put(tag, basicDecorator);
                }
            }
            return ourSceneMap.get(tag);
        }
        return basicDecorator;
    }

    /*
     * WARNING - void declaration
     */
    public void buildList(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildList"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildList"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildList"));
        }
        this.buildListComponent(list, time, sceneContext, (SceneComponent)component);
        this.buildListTargets(list, time, sceneContext, (SceneComponent)component);
        this.buildListChildren(list, time, sceneContext, (SceneComponent)component);
    }

    /*
     * WARNING - void declaration
     */
    public void buildListComponent(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildListComponent"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildListComponent"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildListComponent"));
        }
        this.addBackground(list, sceneContext, (SceneComponent)component);
        this.addContent(list, time, sceneContext, (SceneComponent)component);
        this.addFrame(list, sceneContext, (SceneComponent)component);
    }

    protected void addContent(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "addContent"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "addContent"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "addContent"));
        }
    }

    protected void addBackground(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "addBackground"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "addBackground"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "addBackground"));
        }
        if (sceneContext.getColorSet().drawBackground()) {
            Rectangle rect = new Rectangle();
            component.fillRect(rect);
            DrawComponentBackground.add(list, sceneContext, rect, component.getDrawState().ordinal(), false, false);
        }
    }

    protected void addFrame(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "addFrame"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "addFrame"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "addFrame"));
        }
        Rectangle rect = new Rectangle();
        component.fillRect(rect);
        boolean hasHorizontalConstraints = true;
        boolean hasVerticalConstraints = true;
        DrawComponentFrame.add(list, sceneContext, rect, component.getDrawState().ordinal(), hasHorizontalConstraints, hasVerticalConstraints);
    }

    /*
     * WARNING - void declaration
     */
    protected void buildListChildren(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildListChildren"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildListChildren"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildListChildren"));
        }
        ArrayList<SceneComponent> children = component.getChildren();
        if (children.size() > 0) {
            Rectangle rect = new Rectangle();
            component.fillRect(rect);
            DisplayList.UNClip unClip = list.addClip(sceneContext, rect);
            for (SceneComponent child : children) {
                child.buildDisplayList(time, list, sceneContext);
            }
            list.add(unClip);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildListTargets(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildListTargets"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildListTargets"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/SceneDecorator", "buildListTargets"));
        }
        ArrayList<Target> targets = component.getTargets();
        for (Target target : targets) {
            target.render(list, sceneContext);
        }
    }

    static {
        try {
            ourConstructorMap.put("android.support.constraint.ConstraintLayout", ConstraintLayoutDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("ProgressBar", ProgressBarDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("Button", ButtonDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("TextView", TextViewDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("ImageView", ImageViewDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("CheckBox", CheckBoxDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("RadioButton", RadioButtonDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("SeekBar", SeekBarDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("Switch", SwitchDecorator.class.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

