/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.decorator.SceneDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawTextRegion;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class TextViewDecorator
extends SceneDecorator {
    private static final String DEFAULT_DIM = "15sp";

    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        String textSize;
        void component;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/TextViewDecorator", "addContent"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/TextViewDecorator", "addContent"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/TextViewDecorator", "addContent"));
        }
        Rectangle rect = new Rectangle();
        component.fillDrawRect(time, rect);
        int l = sceneContext.getSwingX(rect.x);
        int t = sceneContext.getSwingY(rect.y);
        int w = sceneContext.getSwingDimension(rect.width);
        int h = sceneContext.getSwingDimension(rect.height);
        String text = ConstraintUtilities.getResolvedText(component.getNlComponent());
        NlComponent nlc = component.getNlComponent();
        Configuration configuration = nlc.getModel().getConfiguration();
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        Integer size = null;
        if (resourceResolver != null && (textSize = nlc.getAttribute("http://schemas.android.com/apk/res/android", "textSize")) != null) {
            size = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, textSize, configuration);
        }
        if (size == null) {
            size = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, DEFAULT_DIM, configuration);
            size = (int)(0.8 * (double)size.intValue());
        }
        String alignment = nlc.getAttribute("http://schemas.android.com/apk/res/android", "textAlignment");
        int align = ConstraintUtilities.getAlignment(alignment);
        String single = nlc.getAttribute("http://schemas.android.com/apk/res/android", "singleLine");
        boolean singleLine = Boolean.parseBoolean(single);
        int baseLineOffset = sceneContext.getSwingDimension(component.getBaseline());
        int scaleSize = sceneContext.getSwingDimension(size.intValue());
        list.add(new DrawTextRegion(l, t, w, h, baseLineOffset, text, singleLine, false, align, 5, scaleSize));
    }
}

