/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class MultiVersionTreeNode
extends UpdaterTreeNode {
    private final DetailsTreeNode myMaxVersionNode;
    private final Collection<DetailsTreeNode> myVersionNodes;

    public MultiVersionTreeNode(Collection<DetailsTreeNode> versionNodes) {
        this.myVersionNodes = versionNodes;
        this.myMaxVersionNode = this.myVersionNodes.stream().max(UpdaterTreeNode::compareTo).orElse(null);
    }

    @Override
    public PackageNodeModel.SelectedState getInitialState() {
        if (this.myMaxVersionNode == null) {
            return PackageNodeModel.SelectedState.NOT_INSTALLED;
        }
        if (this.myMaxVersionNode.getInitialState() == PackageNodeModel.SelectedState.INSTALLED) {
            return PackageNodeModel.SelectedState.INSTALLED;
        }
        for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
            if (updaterTreeNode.getInitialState() == PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            return PackageNodeModel.SelectedState.MIXED;
        }
        return PackageNodeModel.SelectedState.NOT_INSTALLED;
    }

    @Override
    public PackageNodeModel.SelectedState getCurrentState() {
        if (this.myMaxVersionNode == null) {
            return PackageNodeModel.SelectedState.NOT_INSTALLED;
        }
        if (this.myMaxVersionNode.getCurrentState() == PackageNodeModel.SelectedState.INSTALLED) {
            return PackageNodeModel.SelectedState.INSTALLED;
        }
        for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
            if (updaterTreeNode.getCurrentState() == PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            return PackageNodeModel.SelectedState.MIXED;
        }
        return PackageNodeModel.SelectedState.NOT_INSTALLED;
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.getInitialState() == PackageNodeModel.SelectedState.MIXED;
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.getTextRenderer().append(this.getDisplayName());
    }

    @NotNull
    public String getDisplayName() {
        RepoPackage maxPackage = this.myMaxVersionNode.getPackage();
        String maxName = maxPackage.getDisplayName();
        String maxPath = maxPackage.getPath();
        String suffix = maxPath.substring(maxPath.lastIndexOf(59) + 1);
        maxName = StringUtil.trimEnd((String)maxName, (String)suffix).trim();
        String string = maxName = StringUtil.trimEnd((String)maxName, (String)":");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/configure/MultiVersionTreeNode", "getDisplayName"));
        }
        return string;
    }

    @Override
    public String getStatusString() {
        String revision;
        if (this.getInitialState() == PackageNodeModel.SelectedState.INSTALLED) {
            return "Installed";
        }
        if (this.getInitialState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
            return "Not Installed";
        }
        UpdatablePackage p = this.myMaxVersionNode.getItem();
        if (p.hasRemote()) {
            revision = p.getRemote().getVersion().toString();
        } else {
            assert (false);
            revision = p.getLocal().getVersion().toString();
        }
        return "Update Available: " + revision;
    }

    @Override
    protected void setState(PackageNodeModel.SelectedState state) {
        if (state == PackageNodeModel.SelectedState.NOT_INSTALLED) {
            for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
                updaterTreeNode.setState(PackageNodeModel.SelectedState.NOT_INSTALLED);
            }
        } else {
            for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
                updaterTreeNode.resetState();
            }
            if (state == PackageNodeModel.SelectedState.INSTALLED) {
                this.myMaxVersionNode.setState(PackageNodeModel.SelectedState.INSTALLED);
            }
        }
    }
}

