/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.jarutils.DebugKeyProvider;
import com.android.jarutils.KeystoreHelper;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewKeyForm {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.exportSignedPackage.NewKeyForm");
    private JPanel myContentPanel;
    private JTextField myAliasField;
    private JPasswordField myKeyPasswordField;
    private JPasswordField myConfirmKeyPasswordField;
    private JSpinner myValiditySpinner;
    private JTextField myFirstAndLastNameField;
    private JTextField myOrganizationUnitField;
    private JTextField myCityField;
    private JTextField myStateOrProvinceField;
    private JTextField myCountryCodeField;
    private JPanel myCertificatePanel;
    private JTextField myOrganizationField;
    private KeyStore myKeyStore;
    private PrivateKey myPrivateKey;
    private X509Certificate myCertificate;

    public NewKeyForm() {
        this.$$$setupUI$$$();
        this.myValiditySpinner.setModel(new SpinnerNumberModel(25, 1, 1000, 1));
    }

    private int getValidity() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.myValiditySpinner.getModel();
        return model.getNumber().intValue();
    }

    public void init() {
        this.myAliasField.setText(this.generateAlias());
        this.myKeyPasswordField.setName("myKeyPasswordField");
        this.myConfirmKeyPasswordField.setName("myConfirmKeyPasswordField");
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    private boolean findNonEmptyCertificateField() {
        for (Component component : this.myCertificatePanel.getComponents()) {
            if (!(component instanceof JTextField) || ((JTextField)component).getText().trim().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public void createKey() throws CommitStepException {
        if (this.getKeyAlias().length() == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.alias.error", new Object[0]));
        }
        AndroidUtils.checkNewPassword(this.myKeyPasswordField, this.myConfirmKeyPasswordField);
        if (!this.findNonEmptyCertificateField()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.certificate.field.error", new Object[0]));
        }
        this.doCreateKey();
    }

    @NotNull
    private String generateAlias() {
        List<String> aliasList = this.getExistingKeyAliasList();
        String prefix = "key";
        if (aliasList == null) {
            String string = prefix + '0';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/exportSignedPackage/NewKeyForm", "generateAlias"));
            }
            return string;
        }
        HashSet<String> aliasSet = new HashSet<String>();
        for (String alias : aliasList) {
            aliasSet.add(alias.toLowerCase());
        }
        int i = 0;
        while (true) {
            String alias;
            if (!aliasSet.contains(alias = prefix + i)) {
                String string = alias;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/exportSignedPackage/NewKeyForm", "generateAlias"));
                }
                return string;
            }
            ++i;
        }
    }

    @Nullable
    protected abstract List<String> getExistingKeyAliasList();

    private static void buildDName(StringBuilder builder, String prefix, JTextField textField) {
        String value;
        if (textField != null && (value = textField.getText().trim()).length() > 0) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(prefix);
            builder.append('=');
            builder.append(value);
        }
    }

    private String getDName() {
        StringBuilder builder = new StringBuilder();
        NewKeyForm.buildDName(builder, "CN", this.myFirstAndLastNameField);
        NewKeyForm.buildDName(builder, "OU", this.myOrganizationUnitField);
        NewKeyForm.buildDName(builder, "O", this.myOrganizationField);
        NewKeyForm.buildDName(builder, "L", this.myCityField);
        NewKeyForm.buildDName(builder, "ST", this.myStateOrProvinceField);
        NewKeyForm.buildDName(builder, "C", this.myCountryCodeField);
        return builder.toString();
    }

    private void doCreateKey() throws CommitStepException {
        String keystoreLocation = this.getKeyStoreLocation();
        String keystorePassword = new String(this.getKeyStorePassword());
        String keyPassword = new String(this.getKeyPassword());
        String keyAlias = this.getKeyAlias();
        String dname = this.getDName();
        assert (dname != null);
        if (keystorePassword.indexOf(34) >= 0 || keyPassword.indexOf(34) >= 0) {
            throw new CommitStepException("Passwords cannot contain quote character");
        }
        boolean createdStore = false;
        final StringBuilder errorBuilder = new StringBuilder();
        final StringBuilder outBuilder = new StringBuilder();
        try {
            createdStore = KeystoreHelper.createNewStore((String)keystoreLocation, null, (String)keystorePassword, (String)keyAlias, (String)keyPassword, (String)dname, (int)this.getValidity(), (DebugKeyProvider.IKeyGenOutput)new DebugKeyProvider.IKeyGenOutput(){

                public void err(String message) {
                    errorBuilder.append(message).append('\n');
                    LOG.info("Error: " + message);
                }

                public void out(String message) {
                    outBuilder.append(message).append('\n');
                    LOG.info(message);
                }
            });
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            errorBuilder.append(e.getMessage()).append('\n');
        }
        NewKeyForm.normalizeBuilder(errorBuilder);
        NewKeyForm.normalizeBuilder(outBuilder);
        if (createdStore) {
            if (errorBuilder.length() > 0) {
                String prefix = AndroidBundle.message("android.create.new.key.error.prefix", new Object[0]);
                Messages.showErrorDialog((Component)this.myContentPanel, (String)(prefix + '\n' + errorBuilder.toString()));
            }
        } else {
            if (errorBuilder.length() > 0) {
                throw new CommitStepException(errorBuilder.toString());
            }
            if (outBuilder.length() > 0) {
                throw new CommitStepException(outBuilder.toString());
            }
            throw new CommitStepException(AndroidBundle.message("android.cannot.create.new.key.error", new Object[0]));
        }
        this.loadKeystoreAndKey(keystoreLocation, keystorePassword, keyAlias, keyPassword);
    }

    @NotNull
    public char[] getKeyPassword() {
        char[] cArray = this.myKeyPasswordField.getPassword();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/exportSignedPackage/NewKeyForm", "getKeyPassword"));
        }
        return cArray;
    }

    @NotNull
    public String getKeyAlias() {
        String string = this.myAliasField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/exportSignedPackage/NewKeyForm", "getKeyAlias"));
        }
        return string;
    }

    @NotNull
    protected abstract Project getProject();

    @NotNull
    protected abstract char[] getKeyStorePassword();

    @NotNull
    protected abstract String getKeyStoreLocation();

    private void loadKeystoreAndKey(String keystoreLocation, String keystorePassword, String keyAlias, String keyPassword) throws CommitStepException {
        FileInputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(new File(keystoreLocation));
            keyStore.load(fis, keystorePassword.toCharArray());
            this.myKeyStore = keyStore;
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, new KeyStore.PasswordProtection(keyPassword.toCharArray()));
            if (entry == null) {
                throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", keyAlias));
            }
            PrivateKey privateKey = entry.getPrivateKey();
            Certificate certificate = entry.getCertificate();
            if (privateKey == null || certificate == null) {
                throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", keyAlias));
            }
            this.myPrivateKey = privateKey;
            this.myCertificate = (X509Certificate)certificate;
        }
        catch (Exception e) {
            throw new CommitStepException("Error: " + e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void normalizeBuilder(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
    }

    @Nullable
    public KeyStore getKeyStore() {
        return this.myKeyStore;
    }

    @Nullable
    public PrivateKey getPrivateKey() {
        return this.myPrivateKey;
    }

    @Nullable
    public X509Certificate getCertificate() {
        return this.myCertificate;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPasswordField jPasswordField;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JPanel jPanel;
        JSpinner jSpinner;
        JPasswordField jPasswordField2;
        JTextField jTextField7;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.new.key.alias.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAliasField = jTextField7 = new JTextField();
        jPanel2.add((Component)jTextField7, new GridConstraints(0, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.key.password.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyPasswordField = jPasswordField2 = new JPasswordField();
        jPanel2.add((Component)jPasswordField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.key.validity.label"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myValiditySpinner = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(2, 1, 1, 1, 8, 0, 6, 0, new Dimension(60, -1), null, new Dimension(60, -1)));
        this.myCertificatePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Certificate", 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.key.certificate.name.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFirstAndLastNameField = jTextField6 = new JTextField();
        jPanel.add((Component)jTextField6, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.organization.unit.label"));
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOrganizationUnitField = jTextField5 = new JTextField();
        jPanel.add((Component)jTextField5, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.city.label"));
        jPanel.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCityField = jTextField4 = new JTextField();
        jPanel.add((Component)jTextField4, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.state.label"));
        jPanel.add((Component)jLabel7, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStateOrProvinceField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.country.code.label"));
        jPanel.add((Component)jLabel8, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCountryCodeField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.organization.label"));
        jPanel.add((Component)jLabel9, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOrganizationField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.confirm.password.label"));
        jPanel2.add((Component)jLabel10, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfirmKeyPasswordField = jPasswordField = new JPasswordField();
        jPanel2.add((Component)jPasswordField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField7);
        jLabel2.setLabelFor(jPasswordField2);
        jLabel3.setLabelFor(jSpinner);
        jLabel4.setLabelFor(jTextField6);
        jLabel5.setLabelFor(jTextField5);
        jLabel6.setLabelFor(jTextField4);
        jLabel7.setLabelFor(jTextField3);
        jLabel8.setLabelFor(jTextField2);
        jLabel9.setLabelFor(jTextField);
        jLabel10.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

