/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public interface AndroidLintQuickFix {
    public static final AndroidLintQuickFix[] EMPTY_ARRAY = new AndroidLintQuickFix[0];

    public void apply(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull AndroidQuickfixContexts.Context var3);

    public boolean isApplicable(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull AndroidQuickfixContexts.ContextType var3);

    @NotNull
    public String getName();

    public static class LocalFixWrapper
    extends LocalQuickFixOnPsiElement {
        private final AndroidLintQuickFix myFix;

        public LocalFixWrapper(@NotNull AndroidLintQuickFix fix, @NotNull PsiElement start, @NotNull PsiElement end) {
            if (fix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "<init>"));
            }
            if (start == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "<init>"));
            }
            if (end == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "<init>"));
            }
            super(start, end);
            this.myFix = fix;
        }

        @NotNull
        public String getText() {
            String string = this.myFix.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.myFix.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "getFamilyName"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "invoke"));
            }
            this.myFix.apply(startElement, endElement, AndroidQuickfixContexts.BatchContext.getInstance());
        }
    }

    public static class LocalFixWrappee
    implements AndroidLintQuickFix {
        private final LocalQuickFixOnPsiElement myFix;

        public LocalFixWrappee(@NotNull LocalQuickFixOnPsiElement fix) {
            if (fix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrappee", "<init>"));
            }
            this.myFix = fix;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrappee", "apply"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrappee", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrappee", "apply"));
            }
            this.myFix.invoke(startElement.getProject(), startElement.getContainingFile(), startElement, endElement);
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrappee", "isApplicable"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrappee", "isApplicable"));
            }
            if (contextType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrappee", "isApplicable"));
            }
            return startElement.isValid();
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myFix.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrappee", "getName"));
            }
            return string;
        }
    }
}

