/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class TomcatDataSourceDetector
extends DataSourceDetector {
    public void collectDataSources(@NotNull Project project, @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/persistence/TomcatDataSourceDetector", "collectDataSources"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/persistence/TomcatDataSourceDetector", "collectDataSources"));
        }
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        PsiSearchHelper.SERVICE.getInstance((Project)project).processElementsWithWord((element, offsetInElement) -> {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/persistence/TomcatDataSourceDetector", "lambda$collectDataSources$0"));
            }
            if (!(element instanceof XmlTag) || !"Resource".equals(((XmlTag)element).getLocalName())) {
                return true;
            }
            XmlTag xmlTag = (XmlTag)element;
            builder.withName(xmlTag.getAttributeValue("name")).withDriverClass(xmlTag.getAttributeValue("driverClassName")).withUrl(xmlTag.getAttributeValue("url")).withUser(xmlTag.getAttributeValue("username")).withPassword(xmlTag.getAttributeValue("password")).commit("Tomcat.Resource", (Object)xmlTag);
            return true;
        }, (SearchScope)GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.allScope((Project)project), (FileType[])new FileType[]{StdFileTypes.XML}), "Resource", (short)8, true);
    }
}

