/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.CommonBundle;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.actions.CreateGwtEventWithHandlerDialog;
import com.intellij.gwt.actions.GwtCreateActionBase;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateGwtEventWithHandlerAction
extends GwtCreateActionBase {
    private final Ref<String> myHandlerClassName = Ref.create(null);
    private final Ref<String> myHandleMethodName = Ref.create(null);

    public CreateGwtEventWithHandlerAction() {
        super(GwtBundle.message("create.gwt.event.with.handler.action.name", new Object[0]), GwtBundle.message("create.gwt.event.with.handler.action.description", new Object[0]));
    }

    @Override
    protected void doCheckBeforeCreate(String newName, PsiDirectory directory) throws IncorrectOperationException {
        super.doCheckBeforeCreate(newName, directory);
        JavaDirectoryService.getInstance().checkCreateClass(directory, (String)this.myHandlerClassName.get());
        PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)((String)this.myHandleMethodName.get()));
    }

    @Override
    protected void showDialog(@NotNull GwtFacet facet, @NotNull PsiDirectory directory, @NotNull CreateElementActionBase.MyInputValidator validator) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/actions/CreateGwtEventWithHandlerAction", "showDialog"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/gwt/actions/CreateGwtEventWithHandlerAction", "showDialog"));
        }
        if (validator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "com/intellij/gwt/actions/CreateGwtEventWithHandlerAction", "showDialog"));
        }
        Project project = facet.getModule().getProject();
        if (!facet.getSdkVersion().isEventHandlersSupported()) {
            Messages.showErrorDialog((Project)project, (String)GwtBundle.message("error.message.gwt.event.not.supported", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        CreateGwtEventWithHandlerDialog dialog = new CreateGwtEventWithHandlerDialog(project, this.getDialogTitle(), (InputValidator)validator, this.myHandlerClassName, this.myHandleMethodName);
        dialog.show();
    }

    @Override
    @NotNull
    protected PsiElement[] doCreate(String eventClassName, PsiDirectory directory, GwtModule gwtModule) throws Exception {
        String handlerClassName = (String)this.myHandlerClassName.get();
        String handleMethodName = (String)this.myHandleMethodName.get();
        PsiClass eventClass = CreateGwtEventWithHandlerAction.createClassFromTemplate(directory, eventClassName, (FileType)StdFileTypes.JAVA, "GwtEvent.java", "HANDLER_NAME", handlerClassName, "METHOD_NAME", handleMethodName);
        PsiClass handlerClass = CreateGwtEventWithHandlerAction.createClassFromTemplate(directory, handlerClassName, (FileType)StdFileTypes.JAVA, "GwtEventHandler.java", "EVENT_NAME", eventClassName, "METHOD_NAME", handleMethodName);
        PsiElement[] psiElementArray = new PsiElement[]{eventClass, handlerClass};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtEventWithHandlerAction", "doCreate"));
        }
        return psiElementArray;
    }

    @Override
    protected boolean requireGwtModule() {
        return true;
    }

    @Override
    protected String getDialogPrompt() {
        return GwtBundle.message("label.text.event.class.name", new Object[0]);
    }

    @Override
    protected String getDialogTitle() {
        return GwtBundle.message("dialog.title.create.gwt.event.with.handler", new Object[0]);
    }

    protected String getCommandName() {
        return GwtBundle.message("create.gwt.event.with.handler.command.name", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return GwtBundle.message("action.name.create.gwt.event.with.handler", newName);
    }
}

