/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.actions.GwtCreateActionBase;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateGwtUiRendererAction
extends GwtCreateActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.actions.CreateGwtUiRendererAction");
    private static final String ELEMENT_TYPE = "ELEMENT_TYPE";

    public CreateGwtUiRendererAction() {
        super(GwtBundle.message("create.gwt.uirenderer.action.name", new Object[0]), GwtBundle.message("create.gwt.uirenderer.action.description", new Object[0]));
    }

    @Override
    protected void showDialog(GwtFacet facet, PsiDirectory directory, CreateElementActionBase.MyInputValidator validator) {
        Project project = facet.getModule().getProject();
        if (!facet.getSdkVersion().isUiRendererSupported()) {
            Messages.showErrorDialog((Project)project, (String)GwtBundle.message("error.message.uirenderer.is.supported.in.gwt.2.5.or.later", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        super.showDialog(facet, directory, validator);
    }

    @Override
    @NotNull
    protected PsiElement[] doCreate(String name, PsiDirectory directory, GwtModule gwtModule) {
        PsiElement[] psiElementArray = new PsiElement[]{CreateGwtUiRendererAction.doCreate0(name, directory)};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtUiRendererAction", "doCreate"));
        }
        return psiElementArray;
    }

    @Override
    protected boolean requireGwtModule() {
        return true;
    }

    @Override
    protected String getDialogPrompt() {
        return GwtBundle.message("label.text.enter.name.for.new.gwt.uirenderer.class.and.ui.xml.file", new Object[0]);
    }

    @Override
    protected String getDialogTitle() {
        return GwtBundle.message("dialog.title.create.new.gwt.uirenderer.class.and.ui.xml.file", new Object[0]);
    }

    protected String getCommandName() {
        return GwtBundle.message("create.gwt.uirenderer.command.name", new Object[0]);
    }

    public String getActionName(PsiDirectory directory, String newName) {
        return GwtBundle.message("action.name.create.gwt.uirenderer.0.and.1.ui.xml.file", newName, newName);
    }

    @NotNull
    static PsiFile doCreate0(String name, PsiDirectory directory) {
        PsiClass rendererClass = GwtCreateActionBase.createClassFromTemplate(directory, name, (FileType)StdFileTypes.JAVA, "GwtUiRenderer.java", new Object[0]);
        PsiFile rendererPsiFile = rendererClass.getContainingFile();
        Project project = directory.getProject();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, rendererPsiFile.getVirtualFile());
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        if (editor != null) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            PsiTypeElement parameter = CreateGwtUiRendererAction.getInheritedGenericParameter(rendererClass);
            editor.getCaretModel().moveToOffset(parameter.getNavigationElement().getTextOffset());
            TemplateBuilderImpl templateBuilder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)parameter);
            templateBuilder.replaceElement((PsiElement)parameter, "Object");
            Template template = templateBuilder.buildInlineTemplate();
            TemplateManager.getInstance((Project)project).startTemplate(editor, template, false, null, CreateGwtUiRendererAction.getTemplateFinishingCallback(name, directory, editor, rendererClass));
        } else {
            LOG.error("Text editor for file " + rendererPsiFile.getName() + " not found");
        }
        PsiFile psiFile = rendererPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtUiRendererAction", "doCreate0"));
        }
        return psiFile;
    }

    @NotNull
    private static TemplateEditingListener getTemplateFinishingCallback(final String name, final PsiDirectory directory, final Editor editor, final PsiClass rendererClass) {
        TemplateEditingAdapter templateEditingAdapter = new TemplateEditingAdapter(){

            public void templateFinished(Template template, boolean brokenOff) {
                if (!brokenOff) {
                    PsiElement rightBrace;
                    PsiTypeElement element = CreateGwtUiRendererAction.getInheritedGenericParameter(rendererClass);
                    String elementTypeName = element != null ? element.getText() : "Object";
                    String elementQualifiedName = element != null ? element.getType().getCanonicalText() : "java.lang.Object";
                    String text = GwtCreateActionBase.getTextByTemplate(directory, name, "GwtUiRendererContent.java", CreateGwtUiRendererAction.ELEMENT_TYPE, elementTypeName);
                    if (element == null) {
                        text = text.replace("<Object>", "");
                    }
                    if ((rightBrace = rendererClass.getRBrace()) == null) {
                        return;
                    }
                    int offset = rightBrace.getTextOffset();
                    editor.getCaretModel().moveToOffset(offset);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)text);
                    CodeStyleManager.getInstance((Project)directory.getProject()).reformatText(rendererClass.getContainingFile(), offset, offset + text.length());
                    GwtCreateActionBase.createFromTemplateInternal(directory, name, name + ".ui.xml", (FileType)StdFileTypes.XML, "GwtUiRendererLayout.ui.xml", CreateGwtUiRendererAction.ELEMENT_TYPE, elementQualifiedName);
                }
            }
        };
        if (templateEditingAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtUiRendererAction", "getTemplateFinishingCallback"));
        }
        return templateEditingAdapter;
    }

    @Nullable
    private static PsiTypeElement getInheritedGenericParameter(PsiClass psiClass) {
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList == null) {
            return null;
        }
        PsiJavaCodeReferenceElement[] extendsListReferences = extendsList.getReferenceElements();
        if (extendsListReferences.length != 1) {
            return null;
        }
        PsiJavaCodeReferenceElement superClassReference = extendsListReferences[0];
        PsiReferenceParameterList parametersList = superClassReference.getParameterList();
        if (parametersList == null) {
            return null;
        }
        PsiTypeElement[] superClassTypeParameters = parametersList.getTypeParameterElements();
        if (superClassTypeParameters.length != 1) {
            return null;
        }
        return superClassTypeParameters[0];
    }
}

