/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.gradle;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.packaging.GwtCompileOutputRelativePathSuggester;
import com.intellij.gwt.packaging.GwtCompilerOutputElement;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.service.project.data.javaee.JavaeeProjectDataService;

@Order(value=1000)
public class GwtArtifactsDataService
extends JavaeeProjectDataService<WebConfigurationModelData, WebFacet, WebFacetConfiguration, WebFacetType> {
    public GwtArtifactsDataService() {
        super((JavaeeFacetType)WebFacetType.getInstance());
    }

    @NotNull
    public Key<WebConfigurationModelData> getTargetDataKey() {
        Key key = WebConfigurationModelData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/gradle/GwtArtifactsDataService", "getTargetDataKey"));
        }
        return key;
    }

    protected void configureJavaeeModule(@NotNull ModuleData moduleData, @NotNull WebConfigurationModelData javaeeData, @NotNull IdeModifiableModelsProvider modelsProvider) {
        GwtFacet gwtFacet;
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "com/intellij/gwt/gradle/GwtArtifactsDataService", "configureJavaeeModule"));
        }
        if (javaeeData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeData", "com/intellij/gwt/gradle/GwtArtifactsDataService", "configureJavaeeModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/gwt/gradle/GwtArtifactsDataService", "configureJavaeeModule"));
        }
        Module module = modelsProvider.findIdeModule(moduleData);
        if (module != null && (gwtFacet = GwtFacet.getInstance(module)) != null) {
            Project project = module.getProject();
            String relativePath = GwtCompileOutputRelativePathSuggester.suggestRelativeOutputPath(gwtFacet, modelsProvider.getPackagingElementResolvingContext());
            ModifiableArtifactModel modifiableArtifactModel = modelsProvider.getModifiableArtifactModel();
            for (War war : javaeeData.getArtifacts()) {
                String explodedArtifactName = this.resolveArtifactName(moduleData, war.getName(), true);
                GwtArtifactsDataService.addGwtCompilerOutput(modifiableArtifactModel, project, gwtFacet, explodedArtifactName, relativePath);
            }
        }
    }

    protected ArtifactType getArtifactType(boolean exploded) {
        WebArtifactUtil webArtifactUtil = WebArtifactUtil.getInstance();
        return exploded ? webArtifactUtil.getExplodedWarArtifactType() : webArtifactUtil.getWarArtifactType();
    }

    protected Collection<String> resolveArtifactNames(@NotNull ModuleData moduleData, @NotNull WebConfigurationModelData javaeeData) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "com/intellij/gwt/gradle/GwtArtifactsDataService", "resolveArtifactNames"));
        }
        if (javaeeData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeData", "com/intellij/gwt/gradle/GwtArtifactsDataService", "resolveArtifactNames"));
        }
        List wars = javaeeData.getArtifacts();
        ArrayList names = ContainerUtil.newArrayListWithCapacity((int)(wars.size() * 2));
        for (War war : wars) {
            names.add(this.resolveArtifactName(moduleData, war.getName(), false));
            names.add(this.resolveArtifactName(moduleData, war.getName(), true));
        }
        return names;
    }

    private static void addGwtCompilerOutput(@NotNull ModifiableArtifactModel modifiableArtifactModel, @NotNull Project project, @NotNull GwtFacet gwtFacet, @NotNull String artifactName, @NotNull String relativePath) {
        if (modifiableArtifactModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableArtifactModel", "com/intellij/gwt/gradle/GwtArtifactsDataService", "addGwtCompilerOutput"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/gradle/GwtArtifactsDataService", "addGwtCompilerOutput"));
        }
        if (gwtFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtFacet", "com/intellij/gwt/gradle/GwtArtifactsDataService", "addGwtCompilerOutput"));
        }
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/intellij/gwt/gradle/GwtArtifactsDataService", "addGwtCompilerOutput"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/gwt/gradle/GwtArtifactsDataService", "addGwtCompilerOutput"));
        }
        Artifact artifact = modifiableArtifactModel.findArtifact(artifactName);
        if (artifact != null) {
            ModifiableArtifact modifiableArtifact = modifiableArtifactModel.getOrCreateModifiableArtifact(artifact);
            GwtCompilerOutputElement element = new GwtCompilerOutputElement(project, gwtFacet);
            PackagingElementFactory.getInstance().getOrCreateDirectory(modifiableArtifact.getRootElement(), relativePath).addOrFindChild((PackagingElement)element);
        }
    }
}

