/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.gradle;

import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.gwt.sdk.GwtSdkType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtGradleSdkPaths;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class GwtDependencyDataService
extends AbstractProjectDataService<LibraryDependencyData, Module> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.gradle.GwtDependencyDataService");

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/gradle/GwtDependencyDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryDependencyData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/gwt/gradle/GwtDependencyDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/gradle/GwtDependencyDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/gwt/gradle/GwtDependencyDataService", "importData"));
        }
        for (DataNode<LibraryDependencyData> node : toImport) {
            Module module;
            Set paths;
            String path;
            String externalName = ((LibraryDependencyData)node.getData()).getExternalName();
            if (!externalName.startsWith("com.google.gwt:gwt-servlet:") && !externalName.startsWith("com.google.gwt:gwt-user:") || (path = (String)ContainerUtil.getFirstItem((Collection)(paths = ((LibraryData)((LibraryDependencyData)node.getData()).getTarget()).getPaths(LibraryPathType.BINARY)))) == null || (module = modelsProvider.findIdeModule(((LibraryDependencyData)node.getData()).getOwnerModule())) == null) continue;
            GwtDependencyDataService.setupGwtFacet(module, path, modelsProvider);
        }
    }

    private static void setupGwtFacet(@NotNull Module module, @NotNull String pathToGwtJar, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String[] possibleUrls;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/gradle/GwtDependencyDataService", "setupGwtFacet"));
        }
        if (pathToGwtJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToGwtJar", "com/intellij/gwt/gradle/GwtDependencyDataService", "setupGwtFacet"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/gwt/gradle/GwtDependencyDataService", "setupGwtFacet"));
        }
        ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
        GwtFacet gwtFacet = (GwtFacet)facetModel.getFacetByType(GwtFacetType.ID);
        if (gwtFacet == null) {
            GwtFacetType facetType = GwtFacetType.getInstance();
            gwtFacet = facetType.createFacet(module, facetType.getDefaultFacetName(), facetType.createDefaultConfiguration(), (Facet)null);
            facetModel.addFacet((Facet)gwtFacet, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
        }
        GwtFacetConfiguration configuration = (GwtFacetConfiguration)gwtFacet.getConfiguration();
        for (String url : possibleUrls = new String[]{GwtGradleSdkPaths.getSdkUrl((String)pathToGwtJar, (boolean)false), GwtGradleSdkPaths.getSdkUrl((String)pathToGwtJar, (boolean)true)}) {
            GwtSdkType type = GwtSdkManager.getInstance().detectSdkType(url);
            if (type == null) continue;
            configuration.setGwtSdkType(type.getId());
            configuration.setGwtSdkUrl(url);
            break;
        }
        if (configuration.getGwtSdkUrl() == null) {
            LOG.info("Cannot detect GWT SDK location by " + pathToGwtJar);
        }
    }
}

