/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.uiBinder.GwtUiXmlFileUtil;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtUiFieldErrorsInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtUiFieldErrorsInspection");

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/GwtUiFieldErrorsInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtUiFieldErrorsInspection", "checkFile"));
        }
        GwtFacet facet = GwtUiFieldErrorsInspection.getFacet((PsiElement)file);
        if (facet == null) {
            return null;
        }
        if (file instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)file;
            MultiValuesMap<String, XmlAttributeValue> map = GwtUiXmlFileUtil.getFieldNameToAttributeMap(xmlFile);
            if (map != null && !map.isEmpty()) {
                List<PsiClass> psiClasses = UiBinderMappingService.getInstance(facet.getModule()).getBoundClasses((PsiFile)xmlFile);
                if (psiClasses.isEmpty()) {
                    return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)xmlFile, "UiBinder class not found for '" + xmlFile.getName() + "'", isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
                }
                SmartList problems = new SmartList();
                for (Map.Entry entry : map.entrySet()) {
                    XmlAttributeValue attribute;
                    String fieldName = (String)entry.getKey();
                    Collection attributes = (Collection)entry.getValue();
                    if (attributes.size() > 1) {
                        for (XmlAttributeValue attribute2 : attributes) {
                            problems.add(manager.createProblemDescriptor((PsiElement)attribute2, GwtUiFieldErrorsInspection.getValueRange(attribute2), "Duplicate declaration bound to '" + fieldName + "' field", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
                        }
                    }
                    if ((attribute = (XmlAttributeValue)ContainerUtil.getFirstItem((Collection)attributes, null)) == null || StringUtil.isEmpty((String)fieldName)) continue;
                    for (PsiClass psiClass : psiClasses) {
                        PsiField field = psiClass.findFieldByName(fieldName, true);
                        if (field == null) continue;
                        GwtUiFieldErrorsInspection.checkUiField(field, manager, isOnTheFly, (PsiElement)attribute, GwtUiFieldErrorsInspection.getValueRange(attribute), attribute, (List<ProblemDescriptor>)problems);
                    }
                }
                return problems.toArray(new ProblemDescriptor[problems.size()]);
            }
        } else if (file instanceof PsiJavaFile) {
            SmartList problems = new SmartList();
            for (PsiClass psiClass : ((PsiJavaFile)file).getClasses()) {
                List<XmlFile> xmlFiles = UiBinderMappingService.getInstance(facet.getModule()).getUiXmlFiles(psiClass);
                for (XmlFile xmlFile : xmlFiles) {
                    GwtUiFieldErrorsInspection.checkUiBinderClass(psiClass, xmlFile, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
                }
            }
            return problems.toArray(new ProblemDescriptor[problems.size()]);
        }
        return super.checkFile(file, manager, isOnTheFly);
    }

    private static TextRange getValueRange(XmlAttributeValue attribute) {
        return attribute.getValueTextRange().shiftRight(-attribute.getTextRange().getStartOffset());
    }

    private static void checkUiBinderClass(PsiClass psiClass, XmlFile xmlFile, InspectionManager manager, boolean onTheFly, List<ProblemDescriptor> problems) {
        MultiValuesMap<String, XmlAttributeValue> attributes = GwtUiXmlFileUtil.getFieldNameToAttributeMap(xmlFile);
        for (PsiField field : psiClass.getFields()) {
            XmlAttributeValue attribute = attributes != null ? (XmlAttributeValue)attributes.getFirst((Object)field.getName()) : null;
            PsiIdentifier nameIdentifier = field.getNameIdentifier();
            if (attribute != null) {
                GwtUiFieldErrorsInspection.checkUiField(field, manager, onTheFly, (PsiElement)nameIdentifier, new TextRange(0, nameIdentifier.getTextLength()), attribute, problems);
                continue;
            }
            if (!UiBinderUtil.isUiField(field)) continue;
            problems.add(manager.createProblemDescriptor((PsiElement)nameIdentifier, "'" + field.getName() + "' field is not bound to tag in '" + xmlFile.getName() + "' file", onTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static void checkUiField(@NotNull PsiField field, InspectionManager manager, boolean isOnTheFly, PsiElement place, TextRange rangeInPlace, XmlAttributeValue attribute, List<ProblemDescriptor> problems) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/gwt/inspections/GwtUiFieldErrorsInspection", "checkUiField"));
        }
        if (!UiBinderUtil.isUiField(field)) {
            problems.add(manager.createProblemDescriptor(place, rangeInPlace, "'" + field.getName() + "' is not annotated with @UiField", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{new AddAnnotationFix("com.google.gwt.uibinder.client.UiField", (PsiModifierListOwner)field, new String[0])}));
        } else if (field.hasModifierProperty("private")) {
            LocalQuickFix fix = IntentionManager.getInstance().convertToFix((IntentionAction)QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)field, "private", false, false));
            problems.add(manager.createProblemDescriptor(place, rangeInPlace, "@UiField '" + field.getName() + "' should not be 'private'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{fix}));
        } else {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlTag.class);
            if (tag != null && tag.isValid()) {
                PsiType actualType;
                PsiClassType expectedType;
                String className = UiBinderUtil.getComponentClassName(tag);
                PsiClassType tagType = JavaPsiFacade.getElementFactory((Project)field.getProject()).createTypeByFQClassName(className, field.getResolveScope());
                PsiType fieldType = UiBinderUtil.getUnwrappedUiFieldType(field);
                if (UiBinderUtil.isProvidedUiField(field)) {
                    expectedType = tagType;
                    actualType = fieldType;
                } else {
                    expectedType = fieldType;
                    actualType = tagType;
                }
                if (!TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)actualType)) {
                    SetCorrectUiFieldTypeFix fix = new SetCorrectUiFieldTypeFix(field, (PsiType)tagType);
                    problems.add(manager.createProblemDescriptor(place, rangeInPlace, "Expected '" + expectedType.getCanonicalText() + "' but '" + actualType.getCanonicalText() + "' found", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{fix}));
                }
            }
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("@UiField Errors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtUiFieldErrorsInspection", "getDisplayName"));
        }
        return "@UiField Errors";
    }

    @NotNull
    public String getShortName() {
        if ("GwtUiFieldErrors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtUiFieldErrorsInspection", "getShortName"));
        }
        return "GwtUiFieldErrors";
    }

    private static class SetCorrectUiFieldTypeFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.change.field.type", new Object[0]);
        private final PsiField myField;
        private final PsiType myExpectedType;

        private SetCorrectUiFieldTypeFix(PsiField field, PsiType expectedType) {
            super(GwtBundle.message("quickfix.name.change.0.type.to.1", field.getName(), expectedType.getCanonicalText()));
            this.myField = field;
            this.myExpectedType = expectedType;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtUiFieldErrorsInspection$SetCorrectUiFieldTypeFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtUiFieldErrorsInspection$SetCorrectUiFieldTypeFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtUiFieldErrorsInspection$SetCorrectUiFieldTypeFix", "applyFix"));
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.myField)) {
                return;
            }
            PsiTypeElement typeElement = this.myField.getTypeElement();
            LOG.assertTrue(typeElement != null, (Object)this.myField.getText());
            typeElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createTypeElement(this.myExpectedType));
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)this.myField);
        }
    }
}

