/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.make;

import com.intellij.compiler.server.CustomBuilderMessageHandler;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.gwt.make.report.CompileReportsHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class GwtBuilderMessageHandler
implements CustomBuilderMessageHandler {
    private static final Key<String> GWT_MODULE_NAME = Key.create((String)"GWT_MODULE_NAME");
    private final Project myProject;
    private boolean myListenerAdded;

    public GwtBuilderMessageHandler(Project project) {
        this.myProject = project;
    }

    public static GwtBuilderMessageHandler getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/make/GwtBuilderMessageHandler", "getInstance"));
        }
        return (GwtBuilderMessageHandler)ServiceManager.getService((Project)project, GwtBuilderMessageHandler.class);
    }

    public void installExternalGwtBuilderListener() {
        if (this.myListenerAdded) {
            return;
        }
        this.myListenerAdded = true;
        this.myProject.getMessageBus().connect().subscribe(CustomBuilderMessageHandler.TOPIC, (Object)this);
    }

    public void showCompilerOutput(ConsoleView consoleView, String gwtModuleName) {
        ApplicationManager.getApplication().invokeLater(() -> {
            MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
            String name = "'" + StringUtil.getShortName((String)gwtModuleName) + "' GWT output";
            Content content = ContentFactory.SERVICE.getInstance().createContent(consoleView.getComponent(), name, true);
            content.putUserData(GWT_MODULE_NAME, (Object)gwtModuleName);
            ContentManager contentManager = messageView.getContentManager();
            contentManager.addContent(content);
            contentManager.setSelectedContent(content);
            for (Content content2 : contentManager.getContents()) {
                String gwtModuleName2;
                if (content2.isPinned() || content2.equals(content) || !gwtModuleName.equals(gwtModuleName2 = (String)content2.getUserData(GWT_MODULE_NAME))) continue;
                contentManager.removeContent(content2, true);
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
            if (toolWindow != null && !toolWindow.isActive()) {
                toolWindow.activate(null, false);
            }
        });
    }

    public void messageReceived(String builderId, String messageType, String messageText) {
        if (!"GWT".equals(builderId)) {
            return;
        }
        if (messageType.equals("!start!")) {
            TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
            builder.setViewer(true);
            final ConsoleView consoleView = builder.getConsole();
            final String moduleName = messageText;
            this.showCompilerOutput(consoleView, moduleName);
            final MessageBusConnection connection = this.myProject.getMessageBus().connect();
            connection.subscribe(TOPIC, (Object)new CustomBuilderMessageHandler(){

                public void messageReceived(String builderId, String messageType, String messageText) {
                    if (builderId.equals("GWT")) {
                        if (messageType.equals("!finish!")) {
                            connection.disconnect();
                        } else if (messageType.equals(moduleName)) {
                            consoleView.print(messageText, ConsoleViewContentType.NORMAL_OUTPUT);
                        }
                    }
                }
            });
        } else if (messageType.startsWith("!compile-report!")) {
            String moduleName = StringUtil.trimStart((String)messageType, (String)"!compile-report!");
            CompileReportsHistory.getInstance(this.myProject).updateReport(moduleName, System.currentTimeMillis(), messageText);
        }
    }
}

