/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.maven;

import com.intellij.gwt.make.GwtCompilerPaths;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.jps.gwt.model.impl.sdk.JpsGwtDependenciesCache;

public class GwtDependenciesCache
extends JpsGwtDependenciesCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.maven.GwtDependenciesCache");

    public static GwtDependenciesCache getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/maven/GwtDependenciesCache", "getInstance"));
        }
        return (GwtDependenciesCache)((Object)ServiceManager.getService((Project)project, GwtDependenciesCache.class));
    }

    public GwtDependenciesCache(Project project) {
        super(GwtCompilerPaths.getGwtDependencies(project));
    }

    public void persistGwtDependencies(Map<String, Collection<MavenArtifact>> dependenciesMap) {
        this.myDependencies = new JpsGwtDependenciesCache.GwtDependencies();
        for (Map.Entry<String, Collection<MavenArtifact>> entry : dependenciesMap.entrySet()) {
            HashSet dependencies = ContainerUtil.newHashSet();
            for (MavenArtifact dependency : entry.getValue()) {
                dependencies.add(dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion());
            }
            this.myDependencies.myGwtDevDependenciesMap.put(entry.getKey(), dependencies);
        }
        Element element = XmlSerializer.serialize((Object)this.myDependencies);
        try {
            JdomKt.write((Parent)element, (Path)this.myGwtDependenciesFile.toPath());
        }
        catch (IOException e) {
            LOG.error("Unable to save file " + this.myGwtDependenciesFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

