/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.module.model.impl;

import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtFileSet;
import com.intellij.gwt.module.model.GwtInheritsEntry;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.module.model.GwtRelativePath;
import com.intellij.gwt.module.model.GwtStylesheetRef;
import com.intellij.gwt.module.model.impl.GwtFilePatternUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GwtModuleImpl
implements GwtModule {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.module.model.impl.GwtModuleImpl");
    private String myCachedFileUrl;
    private VirtualFile myModuleFile;
    private String myName;
    private String myShortName;
    private VirtualFile myModuleDirectory;
    private GwtModulesManager myGwtModulesManager;

    @Override
    public String getOutputName() {
        String renameTo = (String)this.getRenameTo().getValue();
        if (renameTo != null) {
            return renameTo;
        }
        return this.getQualifiedName();
    }

    @Override
    public String getQualifiedName() {
        this.ensureInitialized();
        return this.myName;
    }

    private void ensureInitialized() {
        String relativePath;
        XmlFile psiFile = this.getModuleXmlFile();
        this.myModuleFile = psiFile.getOriginalFile().getVirtualFile();
        LOG.assertTrue(this.myModuleFile != null);
        if (this.myModuleFile.getUrl().equals(this.myCachedFileUrl)) {
            return;
        }
        this.myModuleDirectory = this.myModuleFile.getParent();
        LOG.assertTrue(this.myModuleDirectory != null);
        Project project = psiFile.getProject();
        this.myGwtModulesManager = GwtModulesManager.getInstance(project);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(this.myModuleFile);
        if (sourceRoot == null) {
            sourceRoot = index.getClassRootForFile(this.myModuleFile);
        }
        String string = relativePath = sourceRoot != null ? VfsUtilCore.getRelativePath((VirtualFile)this.myModuleFile, (VirtualFile)sourceRoot, (char)'.') : this.myModuleFile.getName();
        if (relativePath == null) {
            LOG.error("Module file " + this.myModuleFile.getPath() + " is not under source root " + sourceRoot);
            return;
        }
        this.myName = relativePath.substring(0, relativePath.length() - ".gwt.xml".length());
        this.myShortName = StringUtil.getShortName((String)this.myName);
        this.myCachedFileUrl = this.myModuleFile.getUrl();
    }

    @Override
    public VirtualFile getModuleFile() {
        this.ensureInitialized();
        return this.myModuleFile;
    }

    @Override
    public XmlFile getModuleXmlFile() {
        return DomUtil.getFile((DomElement)this);
    }

    @Override
    public VirtualFile getModuleDirectory() {
        this.ensureInitialized();
        return this.myModuleDirectory;
    }

    @Override
    public List<GwtModule> getInherited(GlobalSearchScope scope) {
        this.ensureInitialized();
        ArrayList<GwtModule> list = new ArrayList<GwtModule>();
        for (GwtInheritsEntry inheritsEntry : this.getInheritses()) {
            GwtModule gwtModule;
            String value = (String)inheritsEntry.getName().getValue();
            if (value == null || (gwtModule = this.myGwtModulesManager.findGwtModuleByQualifiedName(value, scope)) == null) continue;
            list.add(gwtModule);
        }
        return list;
    }

    @Override
    public List<StylesheetFile> getStylesheetFiles() {
        this.ensureInitialized();
        ArrayList<StylesheetFile> list = new ArrayList<StylesheetFile>();
        for (GwtStylesheetRef stylesheetRef : this.getStylesheets()) {
            ContainerUtil.addIfNotNull(list, (Object)stylesheetRef.getSrc().getValue());
        }
        return list;
    }

    @Override
    public String getShortName() {
        this.ensureInitialized();
        return this.myShortName;
    }

    @Override
    public Collection<VirtualFile> getSourceRoots(boolean includeTests) {
        return this.getRootsByRelativePaths(this.getSources(), "client", includeTests).keySet();
    }

    @Override
    public Collection<VirtualFile> getPublicRoots() {
        return this.getPublicRoots(true);
    }

    @Override
    public Collection<VirtualFile> getPublicRoots(boolean includeTests) {
        return this.getRootsByRelativePaths(this.getPublics(), "public", includeTests).keySet();
    }

    @Override
    public Collection<VirtualFile> getSuperSourceRoots(boolean includeTests) {
        return this.getRootsByRelativePaths(this.getSuperSources(), null, includeTests).keySet();
    }

    private List<VirtualFile> getGwtModuleRoots(boolean includeTests) {
        PsiPackage aPackage;
        PsiManager psiManager = PsiManager.getInstance((Project)this.getManager().getProject());
        PsiDirectory psiDirectory = psiManager.findDirectory(this.myModuleDirectory);
        Module module = this.getModule();
        if (module != null && psiDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) != null) {
            GlobalSearchScope baseScope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
            GlobalSearchScope scope = includeTests ? baseScope : baseScope.intersectWith(GlobalSearchScopesCore.projectProductionScope((Project)module.getProject()));
            PsiDirectory[] directories = aPackage.getDirectories(scope);
            if (directories.length > 0) {
                ArrayList roots = ContainerUtil.newArrayListWithCapacity((int)directories.length);
                for (PsiDirectory directory : directories) {
                    roots.add(directory.getVirtualFile());
                }
                return roots;
            }
        }
        return Collections.singletonList(this.myModuleDirectory);
    }

    private Map<VirtualFile, GwtRelativePath> getRootsByRelativePaths(List<GwtRelativePath> relativePaths, @Nullable String defaultPath, boolean includeTests) {
        this.ensureInitialized();
        LinkedHashMap<VirtualFile, GwtRelativePath> roots = new LinkedHashMap<VirtualFile, GwtRelativePath>();
        for (VirtualFile moduleRoot : this.getGwtModuleRoots(includeTests)) {
            VirtualFile file;
            if (relativePaths.size() == 0 && defaultPath != null && (file = moduleRoot.findFileByRelativePath(defaultPath)) != null) {
                roots.put(file, null);
            }
            for (GwtRelativePath relativePath : relativePaths) {
                VirtualFile file2;
                String pathValue = (String)relativePath.getPath().getValue();
                if (pathValue == null || (file2 = moduleRoot.findFileByRelativePath(UriUtil.trimTrailingSlashes((String)FileUtil.toSystemIndependentName((String)pathValue)))) == null) continue;
                roots.put(file2, relativePath);
            }
        }
        return roots;
    }

    @Override
    public boolean isSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/module/model/impl/GwtModuleImpl", "isSourceFile"));
        }
        return GwtModuleImpl.isIncluded(file, this.getSourceRoots());
    }

    @Override
    public Map<VirtualFile, GwtRelativePath> getSourceRoots() {
        return Collections.unmodifiableMap(this.getRootsByRelativePaths(this.getSources(), "client", true));
    }

    @Override
    public Map<VirtualFile, GwtRelativePath> getSuperSourceRoots() {
        return Collections.unmodifiableMap(this.getRootsByRelativePaths(this.getSuperSources(), null, true));
    }

    private static boolean isIncluded(VirtualFile file, Map<VirtualFile, GwtRelativePath> roots) {
        for (Map.Entry<VirtualFile, GwtRelativePath> entry : roots.entrySet()) {
            VirtualFile root = entry.getKey();
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false) || !GwtModuleImpl.isIncluded(file, root, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isIncluded(@NotNull VirtualFile file, @NotNull VirtualFile root, @Nullable GwtRelativePath pathElement) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/module/model/impl/GwtModuleImpl", "isIncluded"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/gwt/module/model/impl/GwtModuleImpl", "isIncluded"));
        }
        if (pathElement == null) {
            return true;
        }
        String path = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
        if (path == null) {
            return false;
        }
        Boolean caseSensitiveValue = (Boolean)pathElement.isCaseSensitive().getValue();
        boolean caseSensitive = caseSensitiveValue == null || caseSensitiveValue != false;
        Boolean defaultExcludes = pathElement.isDefaultExcludes();
        if ((defaultExcludes == null || defaultExcludes.booleanValue()) && GwtFilePatternUtil.isExcludedByDefault(path, caseSensitive)) {
            return false;
        }
        if (GwtModuleImpl.isAccepted(path, pathElement.getExcludes(), caseSensitive) || GwtModuleImpl.isAccepted(path, (String)pathElement.getExcludesAttribute().getValue(), caseSensitive)) {
            return false;
        }
        List<GwtFileSet> includes = pathElement.getIncludes();
        String includesAttribute = (String)pathElement.getIncludesAttribute().getValue();
        return includes.isEmpty() && includesAttribute == null || GwtModuleImpl.isAccepted(path, includes, caseSensitive) || GwtModuleImpl.isAccepted(path, includesAttribute, caseSensitive);
    }

    private static boolean isAccepted(@NotNull String path, @Nullable String patternsString, boolean caseSensitive) {
        String[] patterns;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/gwt/module/model/impl/GwtModuleImpl", "isAccepted"));
        }
        if (patternsString == null) {
            return false;
        }
        for (String pattern : patterns = patternsString.split("(\\s|,)")) {
            if (pattern.length() <= 0 || !GwtFilePatternUtil.createPattern(pattern, caseSensitive).matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean isAccepted(@NotNull String path, List<GwtFileSet> fileSets, boolean caseSensitive) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/gwt/module/model/impl/GwtModuleImpl", "isAccepted"));
        }
        for (GwtFileSet fileSet : fileSets) {
            if (!fileSet.matches(path, caseSensitive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPublicFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/module/model/impl/GwtModuleImpl", "isPublicFile"));
        }
        return GwtModuleImpl.isIncluded(file, this.getRootsByRelativePaths(this.getPublics(), "public", true));
    }
}

