/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssAttributeRSide;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.stubs.CssAttributeStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElement;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.CssSelectorSelfReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssAttributeImpl
extends CssNamedStubElement<CssAttributeStub>
implements CssAttribute {
    public CssAttributeImpl(@NotNull CssAttributeStub stub, @NotNull CssNamedStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssAttributeImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssAttributeImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssAttributeImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssAttributeImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public String getAttributeName() {
        CssAttributeStub stub = (CssAttributeStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeImpl", "getAttributeName"));
            }
            return string;
        }
        String string = (String)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)CssPsiUtil.getTokenText((PsiElement)this.getAttributeNameIdentifier()), (Object[])new Object[]{this}));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeImpl", "getAttributeName"));
        }
        return string;
    }

    @Nullable
    public PsiElement getAttributeNameIdentifier() {
        return this.findChildByType(CssElementTypes.CSS_IDENT);
    }

    @NotNull
    public CssSelectorSuffixType getType() {
        String name = this.getAttributeName();
        if (Comparing.strEqual((String)"class", (String)name, (boolean)false)) {
            CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.CLASS;
            if (cssSelectorSuffixType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeImpl", "getType"));
            }
            return cssSelectorSuffixType;
        }
        if (Comparing.strEqual((String)"id", (String)name, (boolean)false)) {
            CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.ID;
            if (cssSelectorSuffixType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeImpl", "getType"));
            }
            return cssSelectorSuffixType;
        }
        CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.UNKNOWN;
        if (cssSelectorSuffixType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeImpl", "getType"));
        }
        return cssSelectorSuffixType;
    }

    @NotNull
    public String getAttributeValue() {
        CssAttributeStub stub = (CssAttributeStub)this.getStub();
        if (stub != null) {
            String string = stub.getValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeImpl", "getAttributeValue"));
            }
            return string;
        }
        String string = (String)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            CssAttributeRSide rSide = this.getRSide();
            return CachedValueProvider.Result.create((Object)(rSide != null ? rSide.getValue() : ""), (Object[])new Object[]{this});
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeImpl", "getAttributeValue"));
        }
        return string;
    }

    @NotNull
    public CssAttribute.OperatorType getOperatorType() {
        CssAttributeStub stub = (CssAttributeStub)this.getStub();
        if (stub != null) {
            CssAttribute.OperatorType operatorType = stub.getOperatorType();
            if (operatorType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeImpl", "getOperatorType"));
            }
            return operatorType;
        }
        CssAttribute.OperatorType operatorType = (CssAttribute.OperatorType)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            CssAttributeRSide rSide = this.getRSide();
            CssAttribute.OperatorType result = CssAttribute.OperatorType.NONE;
            if (rSide != null) {
                IElementType tokenType;
                PsiElement operatorElement = rSide.getPrevSibling();
                IElementType iElementType = tokenType = operatorElement != null ? operatorElement.getNode().getElementType() : null;
                if (tokenType != null && (CssElementTypes.ATTRIBUTE_OPERATORS.contains(tokenType) || tokenType == CssElementTypes.CSS_JQUERY_NOT_EQUALS)) {
                    if (tokenType == CssElementTypes.CSS_EQ) {
                        result = CssAttribute.OperatorType.EQUALS;
                    } else if (tokenType == CssElementTypes.CSS_INCLUDES) {
                        result = CssAttribute.OperatorType.CONTAINS_WORD;
                    } else if (tokenType == CssElementTypes.CSS_BEGINS_WITH) {
                        result = CssAttribute.OperatorType.STARTS_WITH;
                    } else if (tokenType == CssElementTypes.CSS_CONTAINS) {
                        result = CssAttribute.OperatorType.CONTAINS;
                    } else if (tokenType == CssElementTypes.CSS_ENDS_WITH) {
                        result = CssAttribute.OperatorType.ENDS_WITH;
                    } else if (tokenType == CssElementTypes.CSS_DASHMATCH) {
                        result = CssAttribute.OperatorType.STARTS_WITH_BEFORE_DASH;
                    } else if (tokenType == CssElementTypes.CSS_JQUERY_NOT_EQUALS) {
                        result = CssAttribute.OperatorType.JQUERY_NOT_EQUALS;
                    } else {
                        throw new IllegalArgumentException("Cannot find operator for element type: " + tokenType);
                    }
                }
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{this});
        });
        if (operatorType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeImpl", "getOperatorType"));
        }
        return operatorType;
    }

    @Nullable
    public String getName() {
        return this.getType() != CssSelectorSuffixType.UNKNOWN ? this.getAttributeValue() : null;
    }

    public CssAttribute setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        CssAttributeRSide rSide;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssAttributeImpl", "setName"));
        }
        if (this.getType() != CssSelectorSuffixType.UNKNOWN && (rSide = this.getRSide()) != null) {
            rSide.setValue(name);
        }
        return this;
    }

    public boolean isMatch(@NotNull XmlTag tag, @NotNull CssResolver resolver) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/impl/CssAttributeImpl", "isMatch"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/css/impl/CssAttributeImpl", "isMatch"));
        }
        String name = this.getAttributeName();
        if (name.isEmpty()) {
            return false;
        }
        String attributeValue = tag.getAttributeValue(name);
        if (attributeValue == null) {
            return false;
        }
        return this.isMatch(name, attributeValue);
    }

    @Nullable
    public CssRuleset getRuleset() {
        return (CssRuleset)this.getStubOrPsiParentOfType(CssRuleset.class);
    }

    public boolean isMatch(@NotNull String attributeName, @NotNull String attributeValue) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/psi/css/impl/CssAttributeImpl", "isMatch"));
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/psi/css/impl/CssAttributeImpl", "isMatch"));
        }
        if (!Comparing.strEqual((String)attributeName, (String)this.getAttributeName())) {
            return false;
        }
        String value = this.getAttributeValue();
        switch (this.getOperatorType()) {
            case NONE: {
                return true;
            }
            case EQUALS: {
                return attributeValue.equals(value);
            }
            case CONTAINS_WORD: {
                if (value.isEmpty() || StringUtil.containsWhitespaces((CharSequence)value)) {
                    return false;
                }
                return ContainerUtil.find((Iterable)StringUtil.split((String)value, (String)" \t\n\r"), (Object)value) != null;
            }
            case STARTS_WITH_BEFORE_DASH: {
                return !value.isEmpty() && (attributeValue.equals(value) || attributeValue.startsWith(value + "-"));
            }
            case STARTS_WITH: {
                return !value.isEmpty() && attributeValue.startsWith(value);
            }
            case ENDS_WITH: {
                return !value.isEmpty() && attributeValue.endsWith(value);
            }
            case CONTAINS: {
                return !value.isEmpty() && attributeValue.contains(value);
            }
            case JQUERY_NOT_EQUALS: {
                return !attributeValue.equals(value);
            }
        }
        return true;
    }

    @Nullable
    private CssAttributeRSide getRSide() {
        return (CssAttributeRSide)this.findChildByClass(CssAttributeRSide.class);
    }

    public ItemPresentation getPresentation() {
        CssAttribute.OperatorType operatorType = this.getOperatorType();
        if (this.getIcon(0) != null && this.getOperatorType() == CssAttribute.OperatorType.EQUALS) {
            return new CssNamedItemPresentation((PsiNamedElement)this, "[\"" + this.getAttributeValue() + "\"]");
        }
        if (this.getOperatorType() == CssAttribute.OperatorType.NONE) {
            return new CssNamedItemPresentation((PsiNamedElement)this, "[" + this.getAttributeName() + "]");
        }
        return new CssNamedItemPresentation((PsiNamedElement)this, "[" + this.getAttributeName() + operatorType.getPresentation() + "\"" + this.getAttributeValue() + "\"]");
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.getType().getIcon();
    }

    public int getTextOffset() {
        CssAttributeRSide rSide;
        if (this.getType() != CssSelectorSuffixType.UNKNOWN && (rSide = this.getRSide()) != null) {
            return super.getTextOffset() + rSide.getStartOffsetInParent();
        }
        return super.getTextOffset();
    }

    public PsiReference getReference() {
        CssAttributeRSide rSide;
        if (this.getType() != CssSelectorSuffixType.UNKNOWN && (rSide = this.getRSide()) != null) {
            return new CssSelectorSelfReference((CssSelectorSuffix)this, rSide.getValueTextRange().shiftRight(rSide.getStartOffsetInParent()));
        }
        return super.getReference();
    }
}

