/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssEnterHandler
extends EnterAfterUnmatchedBraceHandler {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/impl/util/editor/CssEnterHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/impl/util/editor/CssEnterHandler", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/intellij/psi/css/impl/util/editor/CssEnterHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/psi/css/impl/util/editor/CssEnterHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/psi/css/impl/util/editor/CssEnterHandler", "preprocessEnter"));
        }
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)((Integer)caretOffset.get()));
        if (!language.isKindOf((Language)CSSLanguage.INSTANCE)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return super.preprocessEnter(file, editor, caretOffset, caretAdvance, dataContext, originalHandler);
    }

    protected Pair<PsiElement, Integer> calculateOffsetToInsertClosingBrace(@NotNull PsiFile file, @NotNull CharSequence text, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/impl/util/editor/CssEnterHandler", "calculateOffsetToInsertClosingBrace"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/util/editor/CssEnterHandler", "calculateOffsetToInsertClosingBrace"));
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document = psiDocumentManager.getDocument(file);
        if (document != null) {
            psiDocumentManager.commitDocument(document);
        }
        PsiElement element = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        ASTNode node = element.getNode();
        int endLineOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)offset, (String)"\n");
        if (node != null && node.getElementType() == TokenType.WHITE_SPACE) {
            return Pair.create(null, (Object)endLineOffset);
        }
        CssBlock cssBlock = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class);
        if (cssBlock != null) {
            boolean isNestedBlock = PsiTreeUtil.getParentOfType((PsiElement)cssBlock, CssBlock.class) != null;
            int blockEndOffset = cssBlock.getTextRange().getEndOffset();
            return Pair.create(null, (Object)(isNestedBlock ? Math.min(endLineOffset, blockEndOffset) : blockEndOffset));
        }
        return Pair.create(null, (Object)endLineOffset);
    }
}

