/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.google.common.base.Joiner;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssTableValueBase<V extends CssTableValue, T>
implements CssTableValue<V, T> {
    private final List<V> myChildren;
    private final T myValue;
    private int myMinCount;
    private int myMaxCount;
    private String myPrefix;
    private String myValuesDelimiter;
    private CssTableValue.Type myType;
    private boolean hasImmutablePrefix;

    protected CssTableValueBase(@NotNull CssTableValue.Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/util/table/CssTableValueBase", "<init>"));
        }
        this(null, type);
    }

    protected CssTableValueBase(@Nullable T value, @NotNull CssTableValue.Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/util/table/CssTableValueBase", "<init>"));
        }
        this.myChildren = new SmartList();
        this.myMinCount = -1;
        this.myMaxCount = -1;
        this.myValuesDelimiter = " ";
        this.hasImmutablePrefix = false;
        this.myValue = value;
        this.myType = type;
    }

    protected CssTableValueBase(@Nullable T value) {
        this(value, CssTableValue.Type.DEFAULT);
    }

    public V addChild(@NotNull V child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/css/impl/util/table/CssTableValueBase", "addChild"));
        }
        this.myChildren.add(child);
        return child;
    }

    protected void removeChild(@NotNull V child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/css/impl/util/table/CssTableValueBase", "removeChild"));
        }
        this.myChildren.remove(child);
    }

    protected void removeAllChildren() {
        this.myChildren.clear();
    }

    public T getValue() {
        return this.myValue;
    }

    @NotNull
    public CssTableValue.Type getType() {
        CssTableValue.Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssTableValueBase", "getType"));
        }
        return type;
    }

    public void setType(@NotNull CssTableValue.Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/util/table/CssTableValueBase", "setType"));
        }
        this.myType = type;
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public void setPrefix(String prefix) {
        this.myPrefix = prefix;
    }

    public boolean hasImmutablePrefix() {
        return this.hasImmutablePrefix;
    }

    public void setHasImmutablePrefix(boolean hasImmutablePrefix) {
        this.hasImmutablePrefix = hasImmutablePrefix;
    }

    public String getValuesDelimiter() {
        return this.myValuesDelimiter;
    }

    public void setValuesDelimiter(String valuesDelimiter) {
        this.myValuesDelimiter = valuesDelimiter;
    }

    public boolean isGroup() {
        return !this.getChildren().isEmpty();
    }

    public int getMinCount() {
        return this.myMinCount;
    }

    public void setMinCount(int minCount) {
        this.myMinCount = minCount;
    }

    public int getMaxCount() {
        return this.myMaxCount;
    }

    public void setMaxCount(int maxCount) {
        this.myMaxCount = maxCount;
    }

    public List<V> getChildren() {
        return this.myChildren;
    }

    public void accept(@NotNull CssTableValueVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/util/table/CssTableValueBase", "accept"));
        }
        visitor.visit((CssTableValue)this);
    }

    public String toString() {
        if (!this.isGroup()) {
            return this.getValue().toString();
        }
        StringBuilder builder = new StringBuilder();
        String separator = " ";
        switch (this.myType) {
            case OR: {
                separator = " | ";
                break;
            }
            case ANY: {
                separator = " || ";
                break;
            }
            case FULL_ANY: {
                separator = " && ";
                break;
            }
        }
        builder.append("[");
        builder.append(Joiner.on((String)separator).join(this.myChildren));
        builder.append("]");
        return builder.toString();
    }
}

