/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CssInvalidMediaFeatureInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidMediaFeatureInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitMediaFeature(@NotNull CssMediaFeature mediaFeature) {
                if (mediaFeature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaFeature", "com/intellij/psi/css/inspections/invalid/CssInvalidMediaFeatureInspection$1", "visitMediaFeature"));
                }
                String name = mediaFeature.getName();
                PsiElement nameIdentifier = mediaFeature.getNameIdentifier();
                if (name.isEmpty() || nameIdentifier == null) {
                    return;
                }
                Collection descriptors = mediaFeature.getDescriptors();
                if (descriptors.isEmpty()) {
                    holder.registerProblem(nameIdentifier, CssBundle.message((String)"css.inspections.invalid.media.feature.unknown.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                Collection filteredDescriptors = CssInspectionsUtil.filterDescriptorsByContextAndCheck(descriptors, nameIdentifier, holder);
                if (!filteredDescriptors.isEmpty()) {
                    filteredDescriptors = CssInspectionsUtil.filterDescriptorsByMediaTypeAndCheck(descriptors, nameIdentifier, holder);
                }
                if (!filteredDescriptors.isEmpty()) {
                    CssInspectionsUtil.checkDescriptorValue(filteredDescriptors, (CssValueOwner)mediaFeature, holder, "css.inspections.media.feature.mismatched.values");
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssInvalidMediaFeatureInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

