/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoriesInspection;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.commons.util.parser.Part;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.spring.data.commons.util.parser.domain.PropertyPath;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataRepositoryMethodParametersInspection
extends SpringDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, PsiClass repositoryClass, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        PsiClass domainClass;
        String methodName;
        PartTree partTree;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "checkRepositoryMethod"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "checkRepositoryMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "checkRepositoryMethod"));
        }
        if (typePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePair", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "checkRepositoryMethod"));
        }
        if (!SpringDataUtil.hasQueryAnnotation(psiMethod) && !SpringDataRepositoryMethodParametersInspection.hasUnresolvedPropertyPaths(partTree = new PartTree(methodName = psiMethod.getName(), domainClass = (PsiClass)typePair.getFirst()))) {
            SpringDataRepositoryMethodParametersInspection.checkParameters(holder, partTree, psiMethod, module, domainClass);
        }
    }

    private static boolean hasUnresolvedPropertyPaths(@NotNull PartTree partTree) {
        if (partTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partTree", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "hasUnresolvedPropertyPaths"));
        }
        for (Part part : partTree.getParts()) {
            for (PropertyPath property : part.getProperty()) {
                PsiType type = property.getType();
                if (type != null) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkParameters(@NotNull ProblemsHolder holder, @NotNull PartTree partTree, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull PsiClass domainClass) {
        PsiIdentifier identifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "checkParameters"));
        }
        if (partTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partTree", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "checkParameters"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "checkParameters"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "checkParameters"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "checkParameters"));
        }
        List<Part> parts = partTree.getParts();
        List<PsiType> requiredParameterTypes = SpringDataRepositoryMethodParametersInspection.getRequiredParameterTypes(parts, domainClass, psiMethod.getProject());
        if (!SpringDataRepositoryMethodParametersInspection.areAssignableTypes(psiMethod, requiredParameterTypes, domainClass) && (identifier = psiMethod.getNameIdentifier()) != null) {
            String text = SpringDataRepositoryMethodParametersInspection.getRequiredParametersTypesToString(requiredParameterTypes, psiMethod.getParameterList());
            holder.registerProblem((PsiElement)identifier, SpringDataBundle.message("required.parameters", text), SpringDataRepositoryMethodParametersInspection.getQuickFixes(psiMethod, parts, domainClass));
        }
    }

    private static LocalQuickFix[] getQuickFixes(PsiMethod psiMethod, Iterable<Part> requiredParameterTypes, PsiClass persistenceEntity) {
        return new LocalQuickFix[]{SpringDataRepositoryMethodParametersInspection.createMethodParametersFix(psiMethod, requiredParameterTypes, persistenceEntity)};
    }

    private static LocalQuickFix createMethodParametersFix(PsiMethod psiMethod, Iterable<Part> nodes, PsiClass psiClass) {
        return new ReplaceAllParametersQuickFix(nodes, psiMethod, psiClass);
    }

    private static void removeOldParameters(PsiMethod psiMethod) {
        PsiParameter[] parameters;
        for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
            parameter.delete();
        }
    }

    private static PsiClassType getObjectClassType(Project project) {
        return PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
    }

    private static boolean areAssignableTypes(@NotNull PsiMethod psiMethod, @NotNull List<PsiType> requiredParameterTypes, @NotNull PsiClass domainClass) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "areAssignableTypes"));
        }
        if (requiredParameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredParameterTypes", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "areAssignableTypes"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "areAssignableTypes"));
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        if (parameters.length == 0 && requiredParameterTypes.size() == 0) {
            return true;
        }
        int requiredParameterIndex = 0;
        for (PsiParameter parameter : parameters) {
            PsiType parameterType = parameter.getType();
            if (SpringDataRepositoryMethodParametersInspection.isNotQueryParameter(psiMethod, parameterType)) continue;
            if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"java.util.Optional")) {
                parameterType = SpringDataRepositoryMethodParametersInspection.getSubstitutedTypeParameters(parameterType, "java.util.Optional");
            }
            if (requiredParameterIndex >= requiredParameterTypes.size()) {
                return false;
            }
            PsiType requiredType = requiredParameterTypes.get(requiredParameterIndex);
            if (requiredType == null || parameterType == null || InheritanceUtil.isInheritor((PsiType)requiredType, (String)"java.util.Collection")) {
                ++requiredParameterIndex;
                continue;
            }
            if (!SpringDataRepositoryMethodParametersInspection.isAssignableOrDomainClassFrom(parameterType, requiredType, domainClass)) {
                return false;
            }
            ++requiredParameterIndex;
        }
        return requiredParameterIndex == requiredParameterTypes.size();
    }

    private static boolean isNotQueryParameter(@NotNull PsiMethod psiMethod, PsiType parameterType) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "isNotQueryParameter"));
        }
        if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"java.lang.Class")) {
            return true;
        }
        if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.domain.Pageable") || InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.domain.Sort")) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.geo.Distance") && InheritanceUtil.isInheritor((PsiType)psiMethod.getReturnType(), (String)"org.springframework.data.geo.GeoResults");
    }

    private static boolean isAssignableOrDomainClassFrom(@NotNull PsiType parameterType, @NotNull PsiType requiredType, @NotNull PsiClass domainClass) {
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "isAssignableOrDomainClassFrom"));
        }
        if (requiredType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredType", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "isAssignableOrDomainClassFrom"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "isAssignableOrDomainClassFrom"));
        }
        if (parameterType.isAssignableFrom(requiredType)) {
            return true;
        }
        PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)parameterType, (boolean)false);
        if (iterableTypeParameter != null && iterableTypeParameter.isAssignableFrom(requiredType)) {
            return true;
        }
        return parameterType instanceof PsiClassType && domainClass.equals(((PsiClassType)parameterType).resolve());
    }

    private static String getRequiredParametersTypesToString(List<PsiType> requiredParameterTypes, PsiParameterList parameterList) {
        String[] types = new String[requiredParameterTypes.size()];
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < requiredParameterTypes.size(); ++i) {
            boolean boldType = true;
            PsiType requiredType = requiredParameterTypes.get(i);
            if (i < parameters.length) {
                PsiType parameterType = parameters[i].getType();
                if (requiredType != null && parameterType.isAssignableFrom(requiredType)) {
                    boldType = false;
                }
            }
            String text = requiredType == null ? SpringDataRepositoryMethodParametersInspection.getUnresolvedTypeText() : XmlStringUtil.escapeString((String)requiredType.getPresentableText());
            types[i] = boldType ? "<b>" + text + "</b>" : text;
        }
        return StringUtil.join((String[])types, (String)", ");
    }

    private static String getUnresolvedTypeText() {
        return "? extends Object";
    }

    @NotNull
    private static List<PsiType> getRequiredParameterTypes(@NotNull Iterable<Part> parts, @NotNull PsiClass domainClass, @NotNull Project project) {
        if (parts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parts", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "getRequiredParameterTypes"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "getRequiredParameterTypes"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "getRequiredParameterTypes"));
        }
        LinkedList<PsiType> psiTypes = new LinkedList<PsiType>();
        for (Part part : parts) {
            PsiType psiType = part.getProperty().getLeafProperty().getType();
            if (psiType == null) continue;
            if (SpringDataRepositoryMethodParametersInspection.isCollectionTypeRequired(part)) {
                psiType = SpringDataRepositoryMethodParametersInspection.createTypedCollection(project, psiType);
            }
            int argumentsNumber = part.getType().getNumberOfArguments();
            for (int i = 0; i < argumentsNumber; ++i) {
                ContainerUtil.addAllNotNull(psiTypes, (Object[])new PsiType[]{psiType});
            }
        }
        LinkedList<PsiType> linkedList = psiTypes;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "getRequiredParameterTypes"));
        }
        return linkedList;
    }

    @Nullable
    private static PsiType createTypedCollection(@NotNull Project project, @NotNull PsiType psiType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "createTypedCollection"));
        }
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "createTypedCollection"));
        }
        PsiClass aClass = SpringDataRepositoryMethodParametersInspection.getCollectionClass(project);
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(aClass, psiType);
    }

    private static boolean isCollectionTypeRequired(@NotNull Part part) {
        if (part == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "part", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "isCollectionTypeRequired"));
        }
        return part.getType() == Part.Type.IN || part.getType() == Part.Type.NOT_IN;
    }

    @Nullable
    private static PsiClass getCollectionClass(Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass("java.util.Collection", GlobalSearchScope.allScope((Project)project));
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringDataRepositoryMethodParametersInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection", "getShortName"));
        }
        return "SpringDataRepositoryMethodParametersInspection";
    }

    private static class ReplaceAllParametersQuickFix
    implements LocalQuickFix {
        private final Iterable<Part> myNodes;
        private final SmartPsiElementPointer<PsiMethod> myPsiMethod;
        private final Map<String, PsiType> myParamsMap;

        public ReplaceAllParametersQuickFix(Iterable<Part> nodes, PsiMethod psiMethod, PsiClass domainClass) {
            this.myNodes = nodes;
            this.myPsiMethod = SmartPointerManager.getInstance((Project)psiMethod.getProject()).createSmartPsiElementPointer((PsiElement)psiMethod);
            this.myParamsMap = ReplaceAllParametersQuickFix.createParamMap(this.myNodes, psiMethod);
        }

        @NotNull
        public String getName() {
            String[] types = new String[this.myParamsMap.size()];
            int i = 0;
            for (String paramName : this.myParamsMap.keySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.myParamsMap.get(paramName).getPresentableText());
                sb.append(" ");
                sb.append(paramName);
                types[i++] = sb.toString();
            }
            String string = SpringDataBundle.message("create.required.parameters", StringUtil.join((String[])types, (String)", "));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringDataBundle.message("create.required.parameters.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "applyFix"));
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod psiMethod = (PsiMethod)this.myPsiMethod.getElement();
            if (psiMethod != null && psiMethod.isValid()) {
                SpringDataRepositoryMethodParametersInspection.removeOldParameters(psiMethod);
                for (Map.Entry<String, PsiType> entry : this.myParamsMap.entrySet()) {
                    psiMethod.getParameterList().add((PsiElement)factory.createParameter(entry.getKey(), entry.getValue()));
                }
            }
        }

        @NotNull
        private static Map<String, PsiType> createParamMap(@NotNull Iterable<Part> nodes, @NotNull PsiMethod psiMethod) {
            String pageable;
            if (nodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "createParamMap"));
            }
            if (psiMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "createParamMap"));
            }
            LinkedHashMap<String, PsiType> paramMap = new LinkedHashMap<String, PsiType>();
            PsiClassType objectClassType = SpringDataRepositoryMethodParametersInspection.getObjectClassType(psiMethod.getProject());
            for (Part node : nodes) {
                PropertyPath nodeProperty = node.getProperty();
                PropertyPath property = nodeProperty.getLeafProperty();
                String propertyName = StringUtil.replace((String)nodeProperty.toDotPath(), (String)".", (String)"_");
                PsiType psiType = property.getType();
                if (psiType == null) continue;
                if (SpringDataRepositoryMethodParametersInspection.isCollectionTypeRequired(node)) {
                    psiType = SpringDataRepositoryMethodParametersInspection.createTypedCollection(psiMethod.getProject(), psiType);
                }
                int argumentsNumber = node.getType().getNumberOfArguments();
                for (int arg = 0; arg < argumentsNumber; ++arg) {
                    String paramName = ReplaceAllParametersQuickFix.getUnusedName(paramMap, propertyName);
                    paramMap.put(paramName, (PsiType)(psiType == null ? objectClassType : psiType));
                }
            }
            if (InheritanceUtil.isInheritor((PsiType)psiMethod.getReturnType(), (String)"org.springframework.data.domain.Page")) {
                pageable = ReplaceAllParametersQuickFix.getUnusedName(paramMap, "pageable");
                PsiType pageablePsiType = ReplaceAllParametersQuickFix.getPsiType(psiMethod.getProject(), "org.springframework.data.domain.Pageable");
                if (pageablePsiType != null) {
                    paramMap.put(pageable, pageablePsiType);
                }
            } else if (InheritanceUtil.isInheritor((PsiType)psiMethod.getReturnType(), (String)"org.springframework.data.geo.GeoResults")) {
                pageable = ReplaceAllParametersQuickFix.getUnusedName(paramMap, "distance");
                PsiType distanceType = ReplaceAllParametersQuickFix.getPsiType(psiMethod.getProject(), "org.springframework.data.geo.Distance");
                if (distanceType != null) {
                    paramMap.put(pageable, distanceType);
                }
            }
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                if (!InheritanceUtil.isInheritor((PsiType)parameter.getType(), (String)"org.springframework.data.domain.Sort")) continue;
                paramMap.put(parameter.getName(), ReplaceAllParametersQuickFix.getPsiType(parameter.getProject(), "org.springframework.data.domain.Sort"));
                break;
            }
            LinkedHashMap<String, PsiType> linkedHashMap = paramMap;
            if (linkedHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "createParamMap"));
            }
            return linkedHashMap;
        }

        @Nullable
        private static PsiType getPsiType(Project project, String fqn) {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass pageableClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
            return pageableClass == null ? null : PsiTypesUtil.getClassType((PsiClass)pageableClass);
        }

        @NotNull
        private static String getUnusedName(@NotNull Map<String, PsiType> paramMap, @NotNull String name) {
            if (paramMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "getUnusedName"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "getUnusedName"));
            }
            String paramName = name;
            int i = 0;
            while (paramMap.containsKey(paramName)) {
                paramName = name + (++i + 1);
            }
            String string = paramName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$ReplaceAllParametersQuickFix", "getUnusedName"));
            }
            return string;
        }
    }
}

