/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.parser;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.data.commons.util.parser.Part;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.spring.data.commons.util.parser.domain.OrderBySource;
import com.intellij.spring.data.commons.util.parser.domain.Sort;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SpringDataParserUtil {
    @NotNull
    public static Map<Part, TextRange> getPartTextRanges(@NotNull PartTree partTree) {
        if (partTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partTree", "com/intellij/spring/data/commons/util/parser/SpringDataParserUtil", "getPartTextRanges"));
        }
        HashMap textRanges = ContainerUtil.newHashMap();
        String methodName = partTree.getSource();
        PartTree.Subject subject = partTree.getSubject();
        int previousPartEndOffset = subject != null && subject.getExpression() != null ? subject.getExpression().length() : 0;
        for (PartTree.OrPart orPart : partTree) {
            Iterator<Part> iterator = orPart.iterator();
            while (iterator.hasNext()) {
                Part part = iterator.next();
                int startOffset = methodName.indexOf(part.getSource(), previousPartEndOffset);
                TextRange range = TextRange.create((int)startOffset, (int)(startOffset + part.getSource().length()));
                textRanges.put(part, range);
                previousPartEndOffset = range.getEndOffset() + (iterator.hasNext() ? "And".length() : "Or".length());
            }
        }
        HashMap hashMap = textRanges;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/util/parser/SpringDataParserUtil", "getPartTextRanges"));
        }
        return hashMap;
    }

    @NotNull
    public static Map<Sort.Order, TextRange> getSortTextRanges(@NotNull PartTree partTree) {
        if (partTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partTree", "com/intellij/spring/data/commons/util/parser/SpringDataParserUtil", "getSortTextRanges"));
        }
        HashMap textRanges = ContainerUtil.newHashMap();
        String methodName = partTree.getSource();
        OrderBySource orderBy = partTree.getOrderBySource();
        if (orderBy != null) {
            TextRange lastTextRange = TextRange.create((int)0, (int)partTree.getSource().indexOf("OrderBy" + orderBy.getSource()));
            for (TextRange range : SpringDataParserUtil.getPartTextRanges(partTree).values()) {
                if (lastTextRange.getEndOffset() >= range.getEndOffset()) continue;
                lastTextRange = range;
            }
            for (Sort.Order order : orderBy.getOrders()) {
                int startOffset = methodName.indexOf(StringUtil.capitalize((String)order.getPropertySourceExpression()), lastTextRange.getEndOffset());
                TextRange range = TextRange.create((int)startOffset, (int)(startOffset + order.getSortExpression().length()));
                textRanges.put(order, range);
                lastTextRange = range;
            }
        }
        HashMap hashMap = textRanges;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/util/parser/SpringDataParserUtil", "getSortTextRanges"));
        }
        return hashMap;
    }
}

