/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.InaccessibleElementVisitor;
import org.jetbrains.plugins.groovy.annotator.ResolveHighlightingVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GrReferenceHighlighter
extends TextEditorHighlightingPass {
    private final GroovyFileBase myFile;
    private List<HighlightInfo> myInfos;

    public GrReferenceHighlighter(@Nullable Document document, @NotNull GroovyFileBase file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/annotator/GrReferenceHighlighter", "<init>"));
        }
        super(file.getProject(), document);
        this.myInfos = null;
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "org/jetbrains/plugins/groovy/annotator/GrReferenceHighlighter", "doCollectInformation"));
        }
        this.myInfos = new ArrayList<HighlightInfo>();
        this.myFile.accept(new ResolveHighlightingVisitor(this.myFile, this.myProject, this.myInfos));
        this.myFile.accept(new InaccessibleElementVisitor(this.myFile, this.myProject, this.myInfos));
    }

    public void doApplyInformationToEditor() {
        if (this.myInfos == null || this.myDocument == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), this.myInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }
}

