/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiSuperMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GroovyGStringKeyInspection
extends BaseInspection {
    private static final String PUT_METHOD = "put";

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "GString is used as map's key #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyGStringKeyInspection", "buildVisitor"));
        }
        return visitor2;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitNamedArgument(@NotNull GrNamedArgument namedArgument) {
            if (namedArgument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyGStringKeyInspection$Visitor", "visitNamedArgument"));
            }
            PsiElement parent = namedArgument.getParent();
            if (parent == null || !(parent instanceof GrListOrMap) || !((GrListOrMap)parent).isMap()) {
                return;
            }
            GrArgumentLabel argumentLabel = namedArgument.getLabel();
            if (argumentLabel == null) {
                return;
            }
            GrExpression labelExpression = argumentLabel.getExpression();
            if (labelExpression == null) {
                return;
            }
            if (Visitor.isGStringType(labelExpression)) {
                this.registerError(argumentLabel);
            }
        }

        @Override
        public void visitExpression(@NotNull GrExpression grExpression) {
            if (grExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grExpression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyGStringKeyInspection$Visitor", "visitExpression"));
            }
            PsiElement gstringParent = grExpression.getParent();
            if (gstringParent == null || !(gstringParent instanceof GrArgumentList)) {
                return;
            }
            GrExpression[] arguments = ((GrArgumentList)gstringParent).getExpressionArguments();
            if (arguments.length != 2 || !arguments[0].equals(grExpression)) {
                return;
            }
            PsiElement grandparent = gstringParent.getParent();
            if (grandparent == null || !(grandparent instanceof GrMethodCall)) {
                return;
            }
            if (!Visitor.isGStringType(grExpression)) {
                return;
            }
            if (!this.isMapPutMethod((GrMethodCall)grandparent)) {
                return;
            }
            this.registerError(grExpression);
        }

        boolean isMapPutMethod(@NotNull GrMethodCall grMethodCall) {
            PsiMethod[] methods;
            if (grMethodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethodCall", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyGStringKeyInspection$Visitor", "isMapPutMethod"));
            }
            PsiMethod method = grMethodCall.resolveMethod();
            if (method == null) {
                return false;
            }
            if (!GroovyGStringKeyInspection.PUT_METHOD.equals(method.getName())) {
                return false;
            }
            PsiClass mapClass = JavaPsiFacade.getInstance((Project)grMethodCall.getProject()).findClass("java.util.Map", grMethodCall.getResolveScope());
            if (mapClass == null) {
                return false;
            }
            for (PsiMethod superMethod : methods = mapClass.findMethodsByName(GroovyGStringKeyInspection.PUT_METHOD, false)) {
                if (!superMethod.equals(method) && !PsiSuperMethodUtil.isSuperMethod((PsiMethod)method, (PsiMethod)superMethod)) continue;
                return true;
            }
            return false;
        }

        private static boolean isGStringType(@NotNull GrExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyGStringKeyInspection$Visitor", "isGStringType"));
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return false;
            }
            PsiClassType type = TypesUtil.createTypeByFQClassName("groovy.lang.GString", expression);
            return type.isAssignableFrom(expressionType);
        }
    }
}

