/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ConvertIntegerToBinaryPredicate
implements PsiElementPredicate {
    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToBinaryPredicate", "satisfiedBy"));
        }
        if (!(element instanceof GrLiteral)) {
            return false;
        }
        GrLiteral expression = (GrLiteral)element;
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(PsiType.INT.equals((Object)type) || PsiType.LONG.equals((Object)type) || type.equalsToText("java.lang.Integer") || type.equalsToText("java.lang.Long"))) {
            return false;
        }
        String text = expression.getText();
        if (text == null || text.isEmpty()) {
            return false;
        }
        if (text.startsWith("0x") || text.startsWith("0X")) {
            return true;
        }
        if (text.startsWith("0b") || text.startsWith("0B")) {
            return false;
        }
        if ("0".equals(text) || "0L".equals(text)) {
            return true;
        }
        return text.charAt(0) != '0';
    }
}

