/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

@ApiStatus.Experimental
public interface GrTypeCalculator<T extends GrExpression> {
    public static final ClassExtension<GrTypeCalculator> EP = new ClassExtension("org.intellij.groovy.typeCalculator");

    @Nullable
    public static PsiType getTypeFromCalculators(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/typing/GrTypeCalculator", "getTypeFromCalculators"));
        }
        for (GrTypeCalculator calculator : EP.forKey(expression.getClass())) {
            PsiType type = calculator.getType(expression);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public PsiType getType(@NotNull T var1);
}

