/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcConfigureNotification
extends GroovyFrameworkConfigNotification {
    private final MvcFramework framework;

    public MvcConfigureNotification(MvcFramework framework) {
        this.framework = framework;
    }

    @Override
    public boolean hasFrameworkStructure(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/mvc/MvcConfigureNotification", "hasFrameworkStructure"));
        }
        return this.framework.hasFrameworkStructure(module) && VfsUtil.findRelativeFile((VirtualFile)this.framework.findAppRoot(module), (String[])new String[]{"application.properties"}) != null;
    }

    @Override
    public boolean hasFrameworkLibrary(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/mvc/MvcConfigureNotification", "hasFrameworkLibrary"));
        }
        return this.framework.hasFrameworkJar(module);
    }

    public EditorNotificationPanel createConfigureNotificationPanel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/mvc/MvcConfigureNotification", "createConfigureNotificationPanel"));
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(this.framework.getFrameworkName() + " SDK is not configured for module '" + module.getName() + '\'');
        for (Map.Entry<String, Runnable> action : this.framework.createConfigureActions(module).entrySet()) {
            panel.createActionLabel(action.getKey(), action.getValue());
        }
        return panel;
    }
}

