/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GroovyOverrideImplementExploreUtil {
    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToOverride(@NotNull GrTypeDefinition aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil", "getMethodSignaturesToOverride"));
        }
        if (aClass.isAnnotationType()) {
            Set<MethodSignature> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil", "getMethodSignaturesToOverride"));
            }
            return set;
        }
        Set<MethodSignature> set = GroovyOverrideImplementExploreUtil.getMapToOverrideImplement(aClass, false, true).keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil", "getMethodSignaturesToOverride"));
        }
        return set;
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToImplement(@NotNull GrTypeDefinition aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil", "getMethodSignaturesToImplement"));
        }
        Set<MethodSignature> set = GroovyOverrideImplementExploreUtil.getMapToOverrideImplement(aClass, true, true).keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil", "getMethodSignaturesToImplement"));
        }
        return set;
    }

    @NotNull
    public static Collection<CandidateInfo> getMethodsToOverrideImplement(GrTypeDefinition aClass, boolean toImplement) {
        Collection<CandidateInfo> collection = GroovyOverrideImplementExploreUtil.getMapToOverrideImplement(aClass, toImplement, true).values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil", "getMethodsToOverrideImplement"));
        }
        return collection;
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(GrTypeDefinition aClass, boolean toImplement, boolean skipImplemented) {
        Collection allMethodSignatures = aClass.getVisibleSignatures();
        Map<MethodSignature, CandidateInfo> map = GroovyOverrideImplementExploreUtil.getMapToOverrideImplement(aClass, allMethodSignatures, toImplement, skipImplemented);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil", "getMapToOverrideImplement"));
        }
        return map;
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(GrTypeDefinition aClass, Collection<HierarchicalMethodSignature> allMethodSignatures, boolean toImplement, boolean skipImplemented) {
        LinkedHashMap abstracts = ContainerUtil.newLinkedHashMap();
        LinkedHashMap finals = ContainerUtil.newLinkedHashMap();
        LinkedHashMap concretes = ContainerUtil.newLinkedHashMap();
        PsiUtilCore.ensureValid((PsiElement)aClass);
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        for (HierarchicalMethodSignature signature : allMethodSignatures) {
            PsiMethod method = signature.getMethod();
            if (method instanceof GrTraitMethod) {
                for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
                    GroovyOverrideImplementExploreUtil.processMethod(aClass, skipImplemented, abstracts, finals, concretes, resolveHelper, superSignature, superSignature.getMethod());
                }
                continue;
            }
            GroovyOverrideImplementExploreUtil.processMethod(aClass, skipImplemented, abstracts, finals, concretes, resolveHelper, signature, method);
        }
        TreeMap<MethodSignature, CandidateInfo> result = new TreeMap<MethodSignature, CandidateInfo>((Comparator<MethodSignature>)new OverrideImplementExploreUtil.MethodSignatureComparator());
        if (toImplement || aClass.isInterface()) {
            GroovyOverrideImplementExploreUtil.collectMethodsToImplement(aClass, abstracts, finals, concretes, result);
        } else {
            for (Map.Entry entry : concretes.entrySet()) {
                PsiMethod abstractOne;
                MethodSignature signature = (MethodSignature)entry.getKey();
                PsiMethod concrete = (PsiMethod)entry.getValue();
                if (finals.get(signature) != null || (abstractOne = (PsiMethod)abstracts.get(signature)) != null && abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true) && !"java.lang.Object".equals(concrete.getContainingClass().getQualifiedName())) continue;
                PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor((PsiMethod)concrete, (PsiSubstitutor)signature.getSubstitutor());
                CandidateInfo info = new CandidateInfo((PsiElement)concrete, subst);
                result.put(signature, info);
            }
        }
        TreeMap<MethodSignature, CandidateInfo> treeMap = result;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil", "getMapToOverrideImplement"));
        }
        return treeMap;
    }

    public static void processMethod(GrTypeDefinition aClass, boolean skipImplemented, Map<MethodSignature, PsiMethod> abstracts, Map<MethodSignature, PsiMethod> finals, Map<MethodSignature, PsiMethod> concretes, PsiResolveHelper resolveHelper, HierarchicalMethodSignature signature, PsiMethod method) {
        PsiMethod implemented;
        PsiUtilCore.ensureValid((PsiElement)method);
        if (method.hasModifierProperty("static") || !resolveHelper.isAccessible((PsiMember)method, (PsiElement)aClass, (PsiClass)aClass)) {
            return;
        }
        PsiClass hisClass = method.getContainingClass();
        if (hisClass == null) {
            return;
        }
        if (method.isConstructor() && (!aClass.isInheritor(hisClass, false) || aClass instanceof PsiAnonymousClass || aClass.isEnum())) {
            return;
        }
        if (skipImplemented && (implemented = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)signature, (boolean)false)) != null && !(implemented instanceof GrTraitMethod) && !(implemented instanceof GrLightMethodBuilder)) {
            return;
        }
        if (method.hasModifierProperty("final")) {
            finals.put((MethodSignature)signature, method);
            return;
        }
        Map<MethodSignature, PsiMethod> map = method.hasModifierProperty("abstract") ? abstracts : concretes;
        GroovyOverrideImplementExploreUtil.fillMap(signature, method, map);
        if (GroovyOverrideImplementExploreUtil.isDefaultMethod(method)) {
            GroovyOverrideImplementExploreUtil.fillMap(signature, method, concretes);
        }
    }

    private static void fillMap(HierarchicalMethodSignature signature, PsiMethod method, Map<MethodSignature, PsiMethod> map) {
        PsiMethod other = map.get(signature);
        if (other == null || GroovyOverrideImplementExploreUtil.preferLeftForImplement(method, other)) {
            map.put((MethodSignature)signature, method);
        }
    }

    private static boolean preferLeftForImplement(PsiMethod left, PsiMethod right) {
        PsiAnnotation[] rightAnnotations;
        if (PsiUtil.getAccessLevel((PsiModifierList)left.getModifierList()) > PsiUtil.getAccessLevel((PsiModifierList)right.getModifierList())) {
            return true;
        }
        PsiClass lClass = left.getContainingClass();
        PsiClass rClass = right.getContainingClass();
        if (lClass != null && !lClass.isInterface()) {
            return true;
        }
        if (rClass != null && !rClass.isInterface()) {
            return false;
        }
        PsiAnnotation[] leftAnnotations = left.getModifierList().getAnnotations();
        return leftAnnotations.length > (rightAnnotations = right.getModifierList().getAnnotations()).length;
    }

    private static boolean isDefaultMethod(PsiMethod method) {
        return method instanceof GrMethod && !method.getModifierList().hasExplicitModifier("abstract") && GrTraitUtil.isTrait(method.getContainingClass());
    }

    public static void collectMethodsToImplement(PsiClass aClass, Map<MethodSignature, PsiMethod> abstracts, Map<MethodSignature, PsiMethod> finals, Map<MethodSignature, PsiMethod> concretes, Map<MethodSignature, CandidateInfo> result) {
        for (Map.Entry<MethodSignature, PsiMethod> entry : abstracts.entrySet()) {
            MethodSignature signature = entry.getKey();
            PsiMethod abstractOne = entry.getValue();
            PsiMethod concrete = concretes.get(signature);
            if (concrete != null && PsiUtil.getAccessLevel((PsiModifierList)concrete.getModifierList()) >= PsiUtil.getAccessLevel((PsiModifierList)abstractOne.getModifierList()) && (abstractOne.getContainingClass().isInterface() || !abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true)) && !GroovyOverrideImplementExploreUtil.isDefaultMethod(abstractOne) || finals.get(signature) != null) continue;
            PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor((PsiMethod)abstractOne, (PsiSubstitutor)signature.getSubstitutor());
            CandidateInfo info = new CandidateInfo((PsiElement)abstractOne, subst);
            result.put(signature, info);
        }
    }
}

