/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Optional;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;

@API(value=API.Usage.Experimental)
public interface Node<C extends EngineExecutionContext> {
    default public C prepare(C context) throws Exception {
        return context;
    }

    default public SkipResult shouldBeSkipped(C context) throws Exception {
        return SkipResult.doNotSkip();
    }

    default public C before(C context) throws Exception {
        return context;
    }

    default public C execute(C context, DynamicTestExecutor dynamicTestExecutor) throws Exception {
        return context;
    }

    default public void after(C context) throws Exception {
    }

    public static interface DynamicTestExecutor {
        public void execute(TestDescriptor var1);
    }

    public static class SkipResult {
        private static final SkipResult alwaysExecuteSkipResult = new SkipResult(false, null);
        private final boolean skipped;
        private final Optional<String> reason;

        public static SkipResult skip(String reason) {
            return new SkipResult(true, reason);
        }

        public static SkipResult doNotSkip() {
            return alwaysExecuteSkipResult;
        }

        private SkipResult(boolean skipped, String reason) {
            this.skipped = skipped;
            this.reason = Optional.ofNullable(reason);
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public Optional<String> getReason() {
            return this.reason;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("skipped", (Object)this.skipped).append("reason", (Object)this.reason.orElse("<unknown>")).toString();
        }
    }
}

