/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ejb;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ejb.EjbGraphAnnotator;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.role.EjbDeclMethodRole;
import com.intellij.javaee.ejb.role.EjbImplMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class EjbEntryPoint
extends EntryPoint {
    private static final String[] ANNOTATIONS = new String[]{"javax.ejb.Schedule"};
    public boolean ADD_EJB_TO_ENTRIES = true;

    public boolean isSelected() {
        return this.ADD_EJB_TO_ENTRIES;
    }

    public void setSelected(boolean selected) {
        this.ADD_EJB_TO_ENTRIES = selected;
    }

    @NotNull
    public String getDisplayName() {
        String string = J2EEBundle.message((String)"ejb.interface.entry.point", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ejb/EjbEntryPoint", "getDisplayName"));
        }
        return string;
    }

    public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/ejb/EjbEntryPoint", "isEntryPoint"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ejb/EjbEntryPoint", "isEntryPoint"));
        }
        if (refElement instanceof RefClass) {
            return EjbGraphAnnotator.isEjb((RefClass)refElement);
        }
        if (refElement instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refElement;
            return EjbGraphAnnotator.isEjbDeclaration(refMethod) || EjbGraphAnnotator.isEjbImplementation(refMethod);
        }
        return false;
    }

    public boolean isEntryPoint(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ejb/EjbEntryPoint", "isEntryPoint"));
        }
        if (psiElement instanceof PsiClass) {
            if (EjbHelper.getEjbHelper().getEjbRole((PsiClass)psiElement) != null) {
                return true;
            }
            for (PsiMethod method : ((PsiClass)psiElement).getMethods()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"javax.ejb.Schedule", (boolean)false)) continue;
                return true;
            }
        }
        if (psiElement instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiElement;
            EjbHelper helper = EjbHelper.getEjbHelper();
            if (helper.getEjbRole(method.getContainingClass()) != null) {
                EjbMethodRole role = helper.getEjbRole(method);
                return role instanceof EjbDeclMethodRole || role instanceof EjbImplMethodRole;
            }
        }
        return false;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.ADD_EJB_TO_ENTRIES) {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        }
    }

    public String[] getIgnoreAnnotations() {
        return this.ADD_EJB_TO_ENTRIES ? ANNOTATIONS : null;
    }
}

